/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.IUserProfile;
import org.jasig.portal.layout.dao.IStylesheetDescriptorDao;
import org.jasig.portal.layout.om.IStylesheetDescriptor;
import org.jasig.portal.url.IUrlNodeSyntaxHelper;
import org.jasig.portal.url.IUrlNodeSyntaxHelperRegistry;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UrlNodeSyntaxHelperRegistryImpl
implements IUrlNodeSyntaxHelperRegistry {
    private IUserInstanceManager userInstanceManager;
    private IStylesheetDescriptorDao stylesheetDescriptorDao;
    private Map<String, IUrlNodeSyntaxHelper> urlNodeSyntaxHelpers = Collections.emptyMap();

    @Autowired
    public void setUrlNodeSyntaxHelpers(Collection<IUrlNodeSyntaxHelper> urlNodeSyntaxHelpers) {
        LinkedHashMap<String, IUrlNodeSyntaxHelper> urlNodeSyntaxHelperBuilder = new LinkedHashMap<String, IUrlNodeSyntaxHelper>();
        for (IUrlNodeSyntaxHelper urlNodeSyntaxHelper : urlNodeSyntaxHelpers) {
            urlNodeSyntaxHelperBuilder.put(urlNodeSyntaxHelper.getName(), urlNodeSyntaxHelper);
        }
        this.urlNodeSyntaxHelpers = Collections.unmodifiableMap(urlNodeSyntaxHelperBuilder);
    }

    @Autowired
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    @Autowired
    public void setStylesheetDescriptorDao(IStylesheetDescriptorDao stylesheetDescriptorDao) {
        this.stylesheetDescriptorDao = stylesheetDescriptorDao;
    }

    public IUrlNodeSyntaxHelper getUrlNodeSyntaxHelper(String name) {
        return (IUrlNodeSyntaxHelper)this.urlNodeSyntaxHelpers.get(name);
    }

    public IUrlNodeSyntaxHelper getCurrentUrlNodeSyntaxHelper(HttpServletRequest request) {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        IUserProfile userProfile = preferencesManager.getUserProfile();
        int themeStylesheetId = userProfile.getThemeStylesheetId();
        IUrlNodeSyntaxHelper themeUrlSyntaxHelper = this.getUrlNodeSyntaxHelperForStylesheet(themeStylesheetId);
        if (themeUrlSyntaxHelper != null) {
            return themeUrlSyntaxHelper;
        }
        int structureStylesheetId = userProfile.getStructureStylesheetId();
        IUrlNodeSyntaxHelper structureUrlSyntaxHelper = this.getUrlNodeSyntaxHelperForStylesheet(structureStylesheetId);
        if (structureUrlSyntaxHelper != null) {
            return structureUrlSyntaxHelper;
        }
        throw new IllegalStateException("No IUrlNodeSyntaxHelper could be found for the current request. Review the IStylesheetDescriptor configuration.");
    }

    public IUrlNodeSyntaxHelper getUrlNodeSyntaxHelperForStylesheet(int stylesheetDescriptorId) {
        IStylesheetDescriptor stylesheetDescriptor = this.stylesheetDescriptorDao.getStylesheetDescriptor((long)stylesheetDescriptorId);
        if (stylesheetDescriptor == null) {
            throw new IllegalArgumentException("No IStylesheetDescriptor found for id: " + stylesheetDescriptorId);
        }
        String themeUrlSyntaxHelperName = stylesheetDescriptor.getUrlNodeSyntaxHelperName();
        if (themeUrlSyntaxHelperName != null) {
            return this.getUrlNodeSyntaxHelper(themeUrlSyntaxHelperName);
        }
        return null;
    }
}

