/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url.processing;

import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.portlet.rendering.IPortletRenderer;
import org.jasig.portal.url.IPortalRequestInfo;
import org.jasig.portal.url.IPortletRequestInfo;
import org.jasig.portal.url.IUrlSyntaxProvider;
import org.jasig.portal.url.ParameterMap;
import org.jasig.portal.url.UrlState;
import org.jasig.portal.url.UrlType;
import org.jasig.portal.url.processing.IRequestParameterProcessor;
import org.jasig.portal.url.processing.PortletRequestParameterProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="portletRequestParameterProcessor")
public class PortletRequestParameterProcessor
implements IRequestParameterProcessor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IUrlSyntaxProvider urlSyntaxProvider;
    private IPortletWindowRegistry portletWindowRegistry;

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    @Autowired
    public void setUrlSyntaxProvider(IUrlSyntaxProvider urlSyntaxProvider) {
        this.urlSyntaxProvider = urlSyntaxProvider;
    }

    public boolean processParameters(HttpServletRequest request, HttpServletResponse response) {
        IPortalRequestInfo portalRequestInfo = this.urlSyntaxProvider.getPortalRequestInfo(request);
        IPortletWindowId targetedPortletWindowId = portalRequestInfo.getTargetedPortletWindowId();
        for (IPortletRequestInfo portletRequestInfo : portalRequestInfo.getPortletRequestInfoMap().values()) {
            IPortletWindowId portletWindowId = portletRequestInfo.getPortletWindowId();
            IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(request, targetedPortletWindowId);
            UrlType urlType = portalRequestInfo.getUrlType();
            switch (1.$SwitchMap$org$jasig$portal$url$UrlType[urlType.ordinal()]) {
                case 1: {
                    Map portletParameters = portletRequestInfo.getPortletParameters();
                    portletWindow.setRenderParameters((Map)ParameterMap.convertListMap((Map)portletParameters));
                }
                case 2: {
                    PortletMode portletMode;
                    WindowState windowState = portletRequestInfo.getWindowState();
                    if (windowState != null) {
                        portletWindow.setWindowState(windowState);
                    }
                    if ((portletMode = portletRequestInfo.getPortletMode()) == null) break;
                    portletWindow.setPortletMode(portletMode);
                    break;
                }
            }
            if (portletWindowId.equals(targetedPortletWindowId)) {
                UrlState urlState = portalRequestInfo.getUrlState();
                switch (1.$SwitchMap$org$jasig$portal$url$UrlState[urlState.ordinal()]) {
                    case 1: {
                        portletWindow.setWindowState(WindowState.MAXIMIZED);
                        break;
                    }
                    case 2: {
                        portletWindow.setWindowState(IPortletRenderer.DETACHED);
                        break;
                    }
                    case 3: {
                        portletWindow.setWindowState(IPortletRenderer.EXCLUSIVE);
                    }
                }
            }
            this.portletWindowRegistry.storePortletWindow(request, portletWindow);
        }
        return true;
    }
}

