/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url.processing;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.layout.IStylesheetUserPreferencesService;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.TransientUserLayoutManagerWrapper;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.url.IPortalRequestInfo;
import org.jasig.portal.url.IPortletRequestInfo;
import org.jasig.portal.url.IUrlSyntaxProvider;
import org.jasig.portal.url.UrlState;
import org.jasig.portal.url.processing.IRequestParameterProcessor;
import org.jasig.portal.url.processing.UserLayoutParameterProcessor;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="userLayoutRequestParameterProcessor")
public class UserLayoutParameterProcessor
implements IRequestParameterProcessor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IUserInstanceManager userInstanceManager;
    private IUrlSyntaxProvider urlSyntaxProvider;
    private IPortletWindowRegistry portletWindowRegistry;
    private IStylesheetUserPreferencesService stylesheetUserPreferencesService;

    @Autowired
    public void setStylesheetUserPreferencesService(IStylesheetUserPreferencesService stylesheetUserPreferencesService) {
        this.stylesheetUserPreferencesService = stylesheetUserPreferencesService;
    }

    @Autowired
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    @Autowired
    public void setUrlSyntaxProvider(IUrlSyntaxProvider urlSyntaxProvider) {
        this.urlSyntaxProvider = urlSyntaxProvider;
    }

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    public boolean processParameters(HttpServletRequest request, HttpServletResponse response) {
        IPortalRequestInfo portalRequestInfo = this.urlSyntaxProvider.getPortalRequestInfo(request);
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        IUserLayoutManager userLayoutManager = preferencesManager.getUserLayoutManager();
        String tabId = portalRequestInfo.getTargetedLayoutNodeId();
        if (tabId != null) {
            this.stylesheetUserPreferencesService.setStylesheetParameter(request, IStylesheetUserPreferencesService.PreferencesScope.STRUCTURE, "focusedTabID", tabId);
        }
        UrlState urlState = portalRequestInfo.getUrlState();
        switch (1.$SwitchMap$org$jasig$portal$url$UrlState[urlState.ordinal()]) {
            case 1: {
                this.stylesheetUserPreferencesService.setStylesheetParameter(request, IStylesheetUserPreferencesService.PreferencesScope.STRUCTURE, "detached", Boolean.TRUE.toString());
            }
            case 2: {
                IPortletRequestInfo portletRequestInfo = portalRequestInfo.getTargetedPortletRequestInfo();
                if (portletRequestInfo != null) {
                    IPortletWindowId targetWindowId = portletRequestInfo.getPortletWindowId();
                    IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(request, targetWindowId);
                    IPortletEntity portletEntity = portletWindow.getPortletEntity();
                    String channelSubscribeId = portletEntity.getLayoutNodeId();
                    this.stylesheetUserPreferencesService.setStylesheetParameter(request, IStylesheetUserPreferencesService.PreferencesScope.STRUCTURE, "userLayoutRoot", channelSubscribeId);
                    if (!(userLayoutManager instanceof TransientUserLayoutManagerWrapper)) break;
                    TransientUserLayoutManagerWrapper transientUserLayoutManagerWrapper = (TransientUserLayoutManagerWrapper)userLayoutManager;
                    transientUserLayoutManagerWrapper.setFocusedId(channelSubscribeId);
                    break;
                }
            }
            default: {
                this.stylesheetUserPreferencesService.setStylesheetParameter(request, IStylesheetUserPreferencesService.PreferencesScope.STRUCTURE, "userLayoutRoot", "root");
            }
        }
        return true;
    }

    protected String findTabIndex(IUserLayoutManager userLayoutManager, String tabId) {
        String rootFolderId = userLayoutManager.getRootFolderId();
        Enumeration rootsChildren = userLayoutManager.getChildIds(rootFolderId);
        int tabIndex = 0;
        String topNodeId = (String)rootsChildren.nextElement();
        while (rootsChildren.hasMoreElements()) {
            ++tabIndex;
            if (tabId.equals(topNodeId)) {
                return Integer.toString(tabIndex);
            }
            topNodeId = (String)rootsChildren.nextElement();
        }
        return "none";
    }
}

