/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url.xml;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jasig.portal.portlet.PortletUtils;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.url.IPortalUrlBuilder;
import org.jasig.portal.url.IPortalUrlProvider;
import org.jasig.portal.url.IPortletUrlBuilder;
import org.jasig.portal.url.IUrlBuilder;
import org.jasig.portal.url.UrlType;
import org.jasig.portal.url.xml.FailSafePortalUrlBuilder;
import org.jasig.portal.url.xml.FailSafePortletUrlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="xslPortalUrlProvider")
public class XsltPortalUrlProvider {
    public static final String XSLT_PORTAL_URL_PROVIDER = "XSLT_PORTAL_URL_PROVIDER";
    public static final String CURRENT_REQUEST = "CURRENT_REQUEST";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IPortalUrlProvider portalUrlProvider;
    private IPortletWindowRegistry portletWindowRegistry;

    public static XsltPortalUrlProvider getUrlProvider(Object urlProvider) {
        return (XsltPortalUrlProvider)urlProvider;
    }

    public static HttpServletRequest getHttpServletRequest(Object request) {
        return (HttpServletRequest)request;
    }

    public static void addParameter(IUrlBuilder urlBuilder, String name, String value) {
        urlBuilder.addParameter(name, new String[]{value});
    }

    @Autowired
    public void setPortalUrlProvider(IPortalUrlProvider urlProvider) {
        this.portalUrlProvider = urlProvider;
    }

    @Autowired
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    public IPortalUrlBuilder getPortalUrlBuilder(HttpServletRequest request, String fname, String layoutId, String type) {
        try {
            UrlType urlType = StringUtils.isEmpty((String)type) ? UrlType.RENDER : UrlType.valueOfIngoreCase((String)type);
            if (StringUtils.isNotEmpty((String)fname)) {
                IPortalUrlBuilder portalUrlBuilderByPortletFName = this.portalUrlProvider.getPortalUrlBuilderByPortletFName(request, fname, urlType);
                return portalUrlBuilderByPortletFName;
            }
            if (StringUtils.isNotEmpty((String)layoutId)) {
                IPortalUrlBuilder portalUrlBuilderByLayoutNode = this.portalUrlProvider.getPortalUrlBuilderByLayoutNode(request, layoutId, urlType);
                return portalUrlBuilderByLayoutNode;
            }
            return this.portalUrlProvider.getDefaultUrl(request);
        }
        catch (Exception e) {
            this.logger.error("Faild to create IPortalUrlBuilder for fname='" + fname + "', layoutId='" + layoutId + "', type='" + type + "'. # will be returned instead.", (Throwable)e);
            return new FailSafePortalUrlBuilder();
        }
    }

    public IPortletUrlBuilder getPortletUrlBuilder(HttpServletRequest request, IPortalUrlBuilder portalUrlBuilder, String fname, String layoutId, String state, String mode, String copyCurrentRenderParameters) {
        IPortletUrlBuilder portletUrlBuilder;
        if (StringUtils.isNotEmpty((String)fname)) {
            IPortletWindow portletWindow = this.portletWindowRegistry.getOrCreateDefaultPortletWindowByFname(request, fname);
            IPortletWindowId portletWindowId = portletWindow.getPortletWindowId();
            portletUrlBuilder = portalUrlBuilder.getPortletUrlBuilder(portletWindowId);
        } else if (StringUtils.isNotEmpty((String)layoutId)) {
            IPortletWindow portletWindow = this.portletWindowRegistry.getOrCreateDefaultPortletWindowByLayoutNodeId(request, layoutId);
            IPortletWindowId portletWindowId = portletWindow.getPortletWindowId();
            portletUrlBuilder = portalUrlBuilder.getPortletUrlBuilder(portletWindowId);
        } else {
            IPortletWindowId targetPortletWindowId = portalUrlBuilder.getTargetPortletWindowId();
            if (targetPortletWindowId == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn("Can only target the default portlet if the root portal-url targets a portlet.", new Throwable());
                } else {
                    this.logger.warn("Can only target the default portlet if the root portal-url targets a portlet. Enable debug for stack trace.");
                }
                return new FailSafePortletUrlBuilder(null, portalUrlBuilder);
            }
            portletUrlBuilder = portalUrlBuilder.getTargetedPortletUrlBuilder();
        }
        portletUrlBuilder.setCopyCurrentRenderParameters(Boolean.parseBoolean(copyCurrentRenderParameters));
        if (StringUtils.isNotEmpty((String)state)) {
            portletUrlBuilder.setWindowState(PortletUtils.getWindowState((String)state));
        }
        if (StringUtils.isNotEmpty((String)mode)) {
            portletUrlBuilder.setPortletMode(PortletUtils.getPortletMode((String)mode));
        }
        return portletUrlBuilder;
    }
}

