/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.Validate;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntPatternFileFilter
implements FileFilter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean acceptDirectories;
    private final boolean ignoreHidden;
    private final Collection<String> includes;
    private final Collection<String> excludes;

    public AntPatternFileFilter(boolean acceptDirectories, boolean ignoreHidden, String include, Collection<String> excludes) {
        Validate.notNull((Object)include);
        Validate.notNull(excludes);
        this.includes = ImmutableSet.of((Object)this.fixAntPattern(include));
        this.excludes = this.fixAntPatterns(excludes);
        this.acceptDirectories = acceptDirectories;
        this.ignoreHidden = ignoreHidden;
    }

    public AntPatternFileFilter(boolean acceptDirectories, boolean ignoreHidden, Collection<String> includes, Collection<String> excludes) {
        Validate.notNull(includes);
        Validate.notNull(excludes);
        this.includes = this.fixAntPatterns(includes);
        this.excludes = this.fixAntPatterns(excludes);
        this.acceptDirectories = acceptDirectories;
        this.ignoreHidden = ignoreHidden;
    }

    protected Collection<String> fixAntPatterns(Collection<String> patterns) {
        ImmutableSet.Builder fixedPatterns = ImmutableSet.builder();
        for (String pattern : patterns) {
            pattern = this.fixAntPattern(pattern);
            fixedPatterns.add((Object)pattern);
        }
        return fixedPatterns.build();
    }

    private String fixAntPattern(String pattern) {
        if (!SelectorUtils.hasWildcards((String)(pattern = FilenameUtils.separatorsToSystem((String)pattern)))) {
            pattern = "**" + File.separatorChar + pattern;
        }
        return pattern;
    }

    @Override
    public boolean accept(File pathname) {
        String path;
        if (this.ignoreHidden && pathname.isHidden()) {
            return false;
        }
        try {
            path = pathname.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not determine canonical path of: " + pathname, e);
        }
        return this.accept(pathname, path);
    }

    protected boolean accept(File pathname, String path) {
        this.logger.debug("checking path: {}", (Object)path);
        for (String include : this.includes) {
            if (this.acceptDirectories && pathname.isDirectory() || SelectorUtils.matchPath((String)include, (String)path, (boolean)false) || SelectorUtils.match((String)include, (String)path, (boolean)false)) {
                this.logger.debug("{} matches include {}", (Object)path, (Object)include);
                for (String exclude : this.excludes) {
                    if (SelectorUtils.matchPath((String)exclude, (String)path, (boolean)false)) {
                        this.logger.debug("{} matches exclude {}", (Object)path, (Object)exclude);
                        this.logger.debug("denied path: {}", (Object)path);
                        return false;
                    }
                    if (!this.logger.isTraceEnabled()) continue;
                    this.logger.trace("{} doesn't match exclude {}", (Object)path, (Object)exclude);
                }
                this.logger.debug("acepted path: {}", (Object)path);
                return true;
            }
            if (!this.logger.isTraceEnabled()) continue;
            this.logger.trace("{} doesn't match include {}", (Object)path, (Object)include);
        }
        this.logger.debug("denied path: {}", (Object)path);
        return false;
    }
}

