/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingList;
import java.util.Collection;

public abstract class FilteringOnAddList<E>
extends ForwardingList<E> {
    private final Function<E, E> filterAdd;
    private final boolean ignoreNull;

    public FilteringOnAddList(Function<E, E> filterAdd, boolean ignoreNull) {
        this.filterAdd = filterAdd;
        this.ignoreNull = ignoreNull;
    }

    public boolean add(E element) {
        if ((element = this.filterAdd.apply(element)) == null && this.ignoreNull) {
            return false;
        }
        return super.add(element);
    }

    public boolean addAll(Collection<? extends E> collection) {
        boolean modified = false;
        for (E element : collection) {
            modified = this.add(element) || modified;
        }
        return modified;
    }

    public void add(int index, E element) {
        if ((element = this.filterAdd.apply(element)) == null && this.ignoreNull) {
            return;
        }
        super.add(index, element);
    }

    public boolean addAll(int index, Collection<? extends E> elements) {
        int size = this.size();
        for (E element : elements) {
            this.add(index, element);
            ++index;
        }
        return size != this.size();
    }
}

