/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.type.IntegerType;
import org.hibernate.type.Type;
import org.jasig.portal.utils.ConcurrentMapUtils;
import org.jasig.portal.utils.ICounterStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.support.TransactionOperations;

@Repository(value="counterStore")
public class HibernateStyleCounterStore
implements ICounterStore {
    private static final String SELECT_QUERY = "SELECT SEQUENCE_VALUE FROM UP_SEQUENCE WHERE SEQUENCE_NAME=?";
    private static final String UPDATE_QUERY = "UPDATE UP_SEQUENCE SET SEQUENCE_VALUE=? WHERE SEQUENCE_NAME=? AND SEQUENCE_VALUE=?";
    private static final String INSERT_QUERY = "INSERT INTO UP_SEQUENCE (SEQUENCE_NAME, SEQUENCE_VALUE) VALUES (?, ?)";
    private final Type identifierType = IntegerType.INSTANCE;
    private final ConcurrentMap<String, Callable<Optimizer>> counterOptimizers = new ConcurrentHashMap();
    private TransactionOperations transactionOperations;
    private JdbcOperations jdbcOperations;
    private int incrementSize = 50;
    private int initialValue = 10;

    @Autowired
    public void setTransactionOperations(@Qualifier(value="PortalDb") TransactionOperations transactionOperations) {
        this.transactionOperations = transactionOperations;
    }

    @Autowired
    public void setJdbcOperations(@Qualifier(value="PortalDb") JdbcOperations jdbcOperations) {
        this.jdbcOperations = jdbcOperations;
    }

    @Value(value="${org.jasig.portal.utils.HibernateStyleCounterStore.incrementSize:50}")
    public void setIncrementSize(int incrementSize) {
        this.incrementSize = incrementSize;
    }

    @Value(value="${org.jasig.portal.utils.HibernateStyleCounterStore.initialValue:10}")
    public void setInitialValue(int initialValue) {
        this.initialValue = initialValue;
    }

    private Optimizer getCounterOptimizer(String counterName) {
        Callable optimizer = (Callable)this.counterOptimizers.get(counterName);
        if (optimizer == null) {
            optimizer = new /* Unavailable Anonymous Inner Class!! */;
            optimizer = (Callable)ConcurrentMapUtils.putIfAbsent((ConcurrentMap)this.counterOptimizers, (Object)counterName, (Object)optimizer);
        }
        try {
            return (Optimizer)optimizer.call();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextId(String counterName) {
        int id;
        Optimizer counterOptimizer;
        Optimizer optimizer = counterOptimizer = this.getCounterOptimizer(counterName);
        synchronized (optimizer) {
            id = this.getNextIdInternal(counterOptimizer, counterName);
        }
        return id;
    }

    private int getNextIdInternal(Optimizer optimizer, String counterName) {
        return (Integer)optimizer.generate((AccessCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ Type access$000(HibernateStyleCounterStore x0) {
        return x0.identifierType;
    }

    static /* synthetic */ int access$100(HibernateStyleCounterStore x0) {
        return x0.incrementSize;
    }

    static /* synthetic */ int access$200(HibernateStyleCounterStore x0) {
        return x0.initialValue;
    }

    static /* synthetic */ JdbcOperations access$300(HibernateStyleCounterStore x0) {
        return x0.jdbcOperations;
    }

    static /* synthetic */ TransactionOperations access$400(HibernateStyleCounterStore x0) {
        return x0.transactionOperations;
    }
}

