/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.SQLServer2005Dialect;
import org.hibernate.service.jdbc.dialect.internal.AbstractDialectResolver;
import org.jasig.portal.utils.MySQL5InnoDBCompressedDialect;
import org.jasig.portal.utils.PostgreSQL81Dialect;

public class PortalDialectResolver
extends AbstractDialectResolver {
    private static final long serialVersionUID = 1L;

    protected final Dialect resolveDialectInternal(DatabaseMetaData metaData) throws SQLException {
        String databaseName = metaData.getDatabaseProductName();
        int databaseMajorVersion = metaData.getDatabaseMajorVersion();
        int databaseMinorVersion = metaData.getDatabaseMinorVersion();
        if ("MySQL".equals(databaseName) && 5 == databaseMajorVersion) {
            return new MySQL5InnoDBCompressedDialect();
        }
        if ("PostgreSQL".equals(databaseName) && 8 == databaseMajorVersion && databaseMinorVersion <= 1) {
            return new PostgreSQL81Dialect();
        }
        if ("Microsoft SQL Server".equals(databaseName) && databaseMajorVersion > 9) {
            return new SQLServer2005Dialect();
        }
        return null;
    }
}

