/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SafeFilenameUtils {
    private static final List<Pattern> WINDOWS_INVALID_PATTERNS = Arrays.asList(Pattern.compile("AUX", 2), Pattern.compile("CLOCK\\$", 2), Pattern.compile("COM\\d*", 2), Pattern.compile("CON", 2), Pattern.compile("LPT\\d*", 2), Pattern.compile("NUL", 2), Pattern.compile("PRN", 2));
    private static Map<Pattern, String> REPLACEMENT_PAIRS = ImmutableMap.builder().put((Object)Pattern.compile("/|\\\\"), (Object)".").put((Object)Pattern.compile("[~`@\\|\\s#$\\*]"), (Object)"_").build();

    private SafeFilenameUtils() {
    }

    public static String makeSafeFilename(String filename) {
        for (Map.Entry pair : REPLACEMENT_PAIRS.entrySet()) {
            Pattern pattern = (Pattern)pair.getKey();
            Matcher matcher = pattern.matcher(filename);
            filename = matcher.replaceAll((String)pair.getValue());
        }
        for (Pattern pattern : WINDOWS_INVALID_PATTERNS) {
            if (!pattern.matcher(filename).matches()) continue;
            filename = "uP-" + filename;
            break;
        }
        return filename;
    }
}

