/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.LinkedList;
import java.util.List;
import org.jasig.portal.utils.TableFormatter;
import org.jvnet.jaxb2_commons.lang.Validate;

public class TableFormatter {
    private final StringBuilder scratchBuilder;
    private final Formatter scratchFormatter;
    private final List<Integer> columnWidths;
    private final List<TableEntry<?>> headerRow;
    private final List<List<TableEntry<?>>> rows = new LinkedList();

    public TableFormatter(TableEntry<?> heading, TableEntry<?> ... headings) {
        this(null, heading, headings);
    }

    public TableFormatter(Formatter f, TableEntry<?> firstHeading, TableEntry<?> ... headings) {
        Validate.notNull(firstHeading);
        this.scratchBuilder = new StringBuilder();
        this.scratchFormatter = new Formatter(this.scratchBuilder, f != null ? f.locale() : null);
        this.columnWidths = new ArrayList(1 + headings.length);
        this.headerRow = new ArrayList(1 + headings.length);
        this.updateColumnSize(0, firstHeading);
        this.headerRow.add(firstHeading);
        for (TableEntry<?> heading : headings) {
            this.updateColumnSize(this.headerRow.size(), heading);
            this.headerRow.add(heading);
        }
    }

    public void addRow(TableEntry<?> firstValue, TableEntry<?> ... values) {
        Validate.notNull(firstValue);
        if (1 + values.length != this.columnWidths.size()) {
            throw new IllegalArgumentException("Inconsistent column count. Expected " + this.columnWidths.size() + " but was " + (1 + values.length));
        }
        ArrayList row = new ArrayList(this.columnWidths.size());
        this.updateColumnSize(row.size(), firstValue);
        row.add(firstValue);
        for (TableEntry<?> value : values) {
            this.updateColumnSize(row.size(), value);
            row.add(value);
        }
        this.rows.add(row);
    }

    private void updateColumnSize(int index, TableEntry<?> value) {
        int valueLength = this.estimateEntryLength(value);
        if (this.columnWidths.size() == index) {
            this.columnWidths.add(valueLength);
        } else {
            this.columnWidths.set(index, Math.max((Integer)this.columnWidths.get(index), valueLength));
        }
    }

    public void format(Formatter formatter) {
        this.formatRow(formatter, this.headerRow);
        this.clearScratchBuilder();
        this.scratchBuilder.append('-');
        for (int column = 0; column < this.columnWidths.size(); ++column) {
            if (column > 0) {
                this.scratchBuilder.append("-+-");
            }
            int width = (Integer)this.columnWidths.get(column);
            for (int i = 0; i < width; ++i) {
                this.scratchBuilder.append('-');
            }
        }
        this.scratchBuilder.append("-%n");
        formatter.format(this.scratchBuilder.toString(), new Object[0]);
        for (List row : this.rows) {
            this.formatRow(formatter, row);
        }
    }

    private void formatRow(Formatter formatter, List<TableEntry<?>> row) {
        this.clearScratchBuilder();
        this.scratchBuilder.append(' ');
        Object[] formatArgs = new Object[this.columnWidths.size()];
        for (int column = 0; column < this.columnWidths.size(); ++column) {
            if (column > 0) {
                this.scratchBuilder.append(" | ");
            }
            int width = (Integer)this.columnWidths.get(column);
            TableEntry<?> header = row.get(column);
            formatArgs[column] = header.getValue();
            this.scratchBuilder.append(header.getFormatString(width));
        }
        this.scratchBuilder.append(" %n");
        formatter.format(this.scratchBuilder.toString(), formatArgs);
    }

    private <T> int estimateEntryLength(TableEntry<T> entry) {
        this.clearScratchBuilder();
        this.scratchFormatter.format(entry.getFormatString(), entry.getValue());
        return this.scratchBuilder.length();
    }

    private void clearScratchBuilder() {
        if (this.scratchBuilder.length() > 0) {
            this.scratchBuilder.delete(0, this.scratchBuilder.length());
        }
    }
}

