/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.cache;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpiredElementEvictor {
    private final ReentrantLock evictLock = new ReentrantLock();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private CacheManager cacheManager;

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictExpiredElements() {
        String[] cacheNames;
        long startTime;
        long evictedTotal = 0L;
        if (!this.evictLock.tryLock()) {
            return;
        }
        try {
            startTime = System.nanoTime();
            for (String cacheName : cacheNames = this.cacheManager.getCacheNames()) {
                Ehcache cache = this.cacheManager.getEhcache(cacheName);
                if (null != cache) {
                    long preEvictSize = cache.getMemoryStoreSize();
                    long evictStart = System.nanoTime();
                    cache.evictExpiredElements();
                    if (!this.logger.isDebugEnabled()) continue;
                    long evicted = preEvictSize - cache.getMemoryStoreSize();
                    evictedTotal += evicted;
                    this.logger.debug("Evicted " + evicted + " elements from cache '" + cacheName + "' in " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - evictStart) + " ms");
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("No cache found with name " + cacheName);
            }
        }
        finally {
            this.evictLock.unlock();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Evicted " + evictedTotal + " elements from " + cacheNames.length + " caches in " + this.cacheManager.getName() + " in " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime) + " ms");
        }
    }
}

