/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.commons.lang.Validate;

public class MapCacheProvider<K extends Serializable, V>
implements Map<K, V> {
    private final Ehcache cache;

    public MapCacheProvider(Ehcache cache) {
        Validate.notNull((Object)cache, (String)"cache can not be null");
        this.cache = cache;
    }

    @Override
    public void clear() {
        this.cache.removeAll();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cache.isKeyInCache(key);
    }

    @Override
    public V get(Object key) {
        Element element = this.cache.get((Serializable)key);
        if (element == null) {
            return null;
        }
        return (V)element.getObjectValue();
    }

    @Override
    public V put(K key, V value) {
        Object old = this.get(key);
        this.cache.put(new Element(key, value));
        return (V)old;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> e : t.entrySet()) {
            Serializable key = (Serializable)e.getKey();
            V value = e.getValue();
            this.cache.put(new Element((Object)key, value));
        }
    }

    @Override
    public V remove(Object key) {
        Object old = this.get(key);
        this.cache.remove((Serializable)key);
        return (V)old;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cache == null ? 0 : this.cache.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapCacheProvider)) {
            return false;
        }
        MapCacheProvider other = (MapCacheProvider)obj;
        return !(this.cache == null ? other.cache != null : !this.cache.equals(other.cache));
    }

    public String toString() {
        return "MapCacheProvider [" + this.cache + "]";
    }

    @Override
    public boolean containsValue(Object value) {
        return this.cache.isValueInCache(value);
    }

    @Override
    public boolean isEmpty() {
        return this.cache.getSize() > 0;
    }

    @Override
    public int size() {
        return this.cache.getSize();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.emptySet();
    }

    @Override
    public Set<K> keySet() {
        return Collections.emptySet();
    }

    @Override
    public Collection<V> values() {
        return Collections.emptySet();
    }
}

