/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.utils.cache.CacheKey;
import org.jasig.portal.utils.cache.PersonDirectoryCacheKeyGenerator;
import org.jasig.portal.utils.cache.UsernameTaggedCacheEntryPurger;
import org.jasig.services.persondir.support.IUsernameAttributeProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springmodules.cache.key.CacheKeyGenerator;

/*
 * Exception performing whole class analysis ignored.
 */
public class PersonDirectoryCacheKeyGenerator
implements CacheKeyGenerator {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final LoadingCache<Method, CachableMethod> resolvedMethodCache = CacheBuilder.newBuilder().build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
    private IUsernameAttributeProvider usernameAttributeProvider;
    private boolean ignoreEmptyAttributes = false;

    @Autowired
    public void setUsernameAttributeProvider(IUsernameAttributeProvider usernameAttributeProvider) {
        this.usernameAttributeProvider = usernameAttributeProvider;
    }

    public void setIgnoreEmptyAttributes(boolean ignoreEmptyAttributes) {
        this.ignoreEmptyAttributes = ignoreEmptyAttributes;
    }

    public Serializable generateKey(MethodInvocation methodInvocation) {
        CachableMethod cachableMethod = (CachableMethod)this.resolvedMethodCache.getUnchecked((Object)methodInvocation.getMethod());
        Object[] methodArguments = methodInvocation.getArguments();
        CacheKey.CacheKeyBuilder cacheKeyBuilder = CacheKey.builder((String)cachableMethod.getName());
        switch (2.$SwitchMap$org$jasig$portal$utils$cache$PersonDirectoryCacheKeyGenerator$CachableMethod[cachableMethod.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                List usernameValueList;
                Map queryMap = (Map)methodArguments[0];
                String usernameAttribute = this.usernameAttributeProvider.getUsernameAttribute();
                Object usernameValue = queryMap.get(usernameAttribute);
                if (usernameValue instanceof String) {
                    cacheKeyBuilder.addTag(UsernameTaggedCacheEntryPurger.createCacheEntryTag((String)((String)usernameValue)));
                } else if (usernameValue instanceof List && (usernameValueList = (List)usernameValue).size() == 1 && (usernameValue = usernameValueList.get(0)) instanceof String) {
                    cacheKeyBuilder.addTag(UsernameTaggedCacheEntryPurger.createCacheEntryTag((String)((String)usernameValue)));
                }
                for (Map.Entry e : queryMap.entrySet()) {
                    String key = (String)e.getKey();
                    Object value = e.getValue();
                    if (this.ignoreEmptyAttributes && (value == null || value instanceof Collection && ((Collection)value).isEmpty() || value instanceof Map && ((Map)value).isEmpty() || value.getClass().isArray() && Array.getLength(value) == 0)) continue;
                    if (value == null || value instanceof Serializable) {
                        cacheKeyBuilder.put((Serializable)((Object)key), (Serializable)value);
                        continue;
                    }
                    cacheKeyBuilder.put((Serializable)((Object)key), value.getClass());
                }
                break;
            }
            case 5: {
                String uid = (String)methodArguments[0];
                if (StringUtils.isEmpty((String)uid)) break;
                cacheKeyBuilder.add((Serializable)((Object)uid));
                cacheKeyBuilder.addTag(UsernameTaggedCacheEntryPurger.createCacheEntryTag((String)uid));
                break;
            }
            case 6: 
            case 7: {
                String uid = (String)methodArguments[0];
                if (StringUtils.isEmpty((String)uid)) break;
                cacheKeyBuilder.add((Serializable)((Object)uid));
                cacheKeyBuilder.addTag(UsernameTaggedCacheEntryPurger.createCacheEntryTag((String)uid));
                break;
            }
            case 8: 
            case 9: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported CachableMethod resolved: '" + cachableMethod + "'");
            }
        }
        if (cacheKeyBuilder.size() == 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No cache key generated for MethodInvocation='" + methodInvocation + "'"));
            }
            return null;
        }
        CacheKey cacheKey = cacheKeyBuilder.build();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Generated cache key '" + cacheKey + "' for MethodInvocation='" + methodInvocation + "'"));
        }
        return cacheKey;
    }

    protected CachableMethod resolveCacheableMethod(Method targetMethod) {
        Class<?> targetClass = targetMethod.getDeclaringClass();
        for (CachableMethod cachableMethod : CachableMethod.values()) {
            Method cacheableMethod = null;
            try {
                cacheableMethod = targetClass.getMethod(cachableMethod.getName(), cachableMethod.getArgs());
            }
            catch (SecurityException e) {
                this.logger.warn((Object)("Security exception while attempting to if the target class '" + targetClass + "' implements the cachable method '" + cachableMethod + "'"), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                String message = "Taret class '" + targetClass + "' does not implement possible cachable method '" + cachableMethod + "'. Is the advice applied to the correct bean and methods?";
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)message, (Throwable)e);
                }
                this.logger.warn((Object)message);
            }
            if (!targetMethod.equals(cacheableMethod)) continue;
            return cachableMethod;
        }
        throw new IllegalArgumentException("Do not know how to generate a cache for for '" + targetMethod + "' on class '" + targetClass + "'. Is the advice applied to the correct bean and methods?");
    }
}

