/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.cache;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Properties;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheEventListenerAdapter;
import net.sf.ehcache.event.CacheEventListenerFactory;
import org.apache.commons.lang.StringUtils;
import org.jasig.portal.utils.cache.SpringCacheEventListenerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SpringCacheEventListenerFactory
extends CacheEventListenerFactory
implements DisposableBean {
    public static final String BEAN_NAME = "beanName";
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringCacheEventListenerFactory.class);
    private static final CacheEventListener NOOP_CACHE_EVENT_LISTENER = new CacheEventListenerAdapter();
    private static volatile Map<String, CacheEventListener> cacheEventListeners;

    @Autowired
    public void setCacheEventListeners(Map<String, CacheEventListener> cacheEventListeners) {
        SpringCacheEventListenerFactory.cacheEventListeners = ImmutableMap.copyOf(cacheEventListeners);
    }

    public void destroy() throws Exception {
        cacheEventListeners = null;
    }

    public CacheEventListener createCacheEventListener(Properties properties) {
        String beanName = StringUtils.trimToNull((String)properties.getProperty(BEAN_NAME));
        if (beanName == null) {
            throw new IllegalArgumentException("The beanName property must be set");
        }
        return new LazyCacheEventListener(beanName);
    }

    static /* synthetic */ Map access$000() {
        return cacheEventListeners;
    }

    static /* synthetic */ CacheEventListener access$100() {
        return NOOP_CACHE_EVENT_LISTENER;
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }
}

