/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.cache;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Resource;
import org.jasig.portal.events.LogoutEvent;
import org.jasig.portal.utils.cache.CacheEntryTag;
import org.jasig.portal.utils.cache.SimpleCacheEntryTag;
import org.jasig.portal.utils.cache.TaggedCacheEntryPurger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class UsernameTaggedCacheEntryPurger
implements ApplicationListener<LogoutEvent> {
    public static final String TAG_TYPE = "username";
    private TaggedCacheEntryPurger taggedCacheEntryPurger;
    private Set<String> ignoredUserNames = Collections.emptySet();

    public static CacheEntryTag createCacheEntryTag(String username) {
        return new SimpleCacheEntryTag("username", (Object)username);
    }

    @Resource(name="UsernameCacheTagPurger_IgnoredUsernames")
    public void setIgnoredUserNames(Set<String> ignoredUserNames) {
        this.ignoredUserNames = ImmutableSet.copyOf(ignoredUserNames);
    }

    @Autowired
    public void setTaggedCacheEntryPurger(TaggedCacheEntryPurger taggedCacheEntryPurger) {
        this.taggedCacheEntryPurger = taggedCacheEntryPurger;
    }

    public void onApplicationEvent(LogoutEvent event) {
        String userName = event.getUserName();
        this.purgeTaggedCacheEntries(userName);
    }

    public void purgeTaggedCacheEntries(String username) {
        if (!this.ignoredUserNames.contains(username)) {
            CacheEntryTag tag = UsernameTaggedCacheEntryPurger.createCacheEntryTag((String)username);
            this.taggedCacheEntryPurger.purgeCacheEntries(tag);
        }
    }
}

