/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.cache.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.jasig.portal.utils.cache.resource.LoadedResource;
import org.jasig.portal.utils.cache.resource.LoadedResourceImpl;
import org.jasig.portal.utils.cache.resource.Loader;
import org.jasig.portal.utils.cache.resource.TemplatesBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Service;

@Service
public class TemplatesBuilder
implements Loader<Templates>,
ResourceLoaderAware {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ResourceLoader resourceLoader;
    private Map<String, Object> transformerAttributes;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setTransformerAttributes(Map<String, Object> transformerAttributes) {
        this.transformerAttributes = transformerAttributes;
    }

    public LoadedResource<Templates> loadResource(Resource resource) throws IOException {
        Templates templates;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (this.transformerAttributes != null) {
            for (Map.Entry attributeEntry : this.transformerAttributes.entrySet()) {
                transformerFactory.setAttribute((String)attributeEntry.getKey(), attributeEntry.getValue());
            }
        }
        ResourceTrackingURIResolver uriResolver = new ResourceTrackingURIResolver(this.resourceLoader);
        transformerFactory.setURIResolver((URIResolver)uriResolver);
        URI uri = resource.getURI();
        String systemId = uri.toString();
        InputStream stream = resource.getInputStream();
        try {
            StreamSource source = new StreamSource(stream, systemId);
            templates = transformerFactory.newTemplates(source);
        }
        catch (TransformerConfigurationException e) {
            throw new IOException("Failed to parse stream into Templates", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        Map resolvedResources = uriResolver.getResolvedResources();
        return new LoadedResourceImpl((Object)templates, resolvedResources);
    }
}

