/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.threading;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import org.jasig.portal.utils.threading.DelegatingThreadPoolTaskScheduler;
import org.jasig.portal.utils.threading.ThreadNamingRunnable;
import org.joda.time.ReadableDuration;
import org.springframework.scheduling.SchedulingTaskExecutor;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.ScheduledMethodRunnable;

public class DelegatingThreadPoolTaskScheduler
extends ThreadPoolTaskScheduler
implements TaskScheduler,
SchedulingTaskExecutor {
    private static final long serialVersionUID = 1L;
    private volatile long initialized = System.currentTimeMillis();
    private volatile long lastStartDelay = 0L;
    private ExecutorService executorService;
    private long initialDelay = 0L;

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setInitialDelay(ReadableDuration initialDelay) {
        this.lastStartDelay = this.initialDelay = initialDelay.getMillis();
    }

    public void afterPropertiesSet() {
        this.initialized = System.currentTimeMillis();
        super.afterPropertiesSet();
    }

    protected long getAdditionalStartDelay() {
        if (this.lastStartDelay != 0L) {
            this.lastStartDelay = Math.max(0L, this.initialDelay - (System.currentTimeMillis() - this.initialized));
            this.logger.debug((Object)("Calculated additionalStartDelay of: " + this.lastStartDelay));
        }
        return this.lastStartDelay;
    }

    protected Date getDelayedStartDate(Date startDate) {
        long additionalStartDelay = this.getAdditionalStartDelay();
        if (additionalStartDelay > 0L) {
            Date newStartDate = new Date(startDate.getTime() + additionalStartDelay);
            this.logger.debug((Object)("Updated startDate with additionalStartDelay from " + startDate + " to " + newStartDate));
            return newStartDate;
        }
        return startDate;
    }

    protected Runnable wrapRunnable(Runnable task) {
        if (task instanceof ScheduledMethodRunnable) {
            Method method = ((ScheduledMethodRunnable)task).getMethod();
            String methodName = method.getName();
            return new ThreadNamingRunnable("-" + methodName, task);
        }
        return task;
    }

    public void execute(Runnable task, long startTimeout) {
        task = this.wrapRunnable(task);
        DelegatingRunnable delegatingRunnable = new DelegatingRunnable(this.executorService, task);
        super.execute((Runnable)delegatingRunnable, startTimeout);
    }

    public Future<?> submit(Runnable task) {
        task = this.wrapRunnable(task);
        DelegatingRunnable delegatingRunnable = new DelegatingRunnable(this.executorService, task);
        return super.submit((Runnable)delegatingRunnable);
    }

    public <T> Future<T> submit(Callable<T> task) {
        DelegatingCallable delegatingCallable = new DelegatingCallable(this.executorService, task);
        Future future = super.submit((Callable)delegatingCallable);
        return new DelegatingForwardingFuture(future);
    }

    public void execute(Runnable task) {
        task = this.wrapRunnable(task);
        DelegatingRunnable delegatingRunnable = new DelegatingRunnable(this.executorService, task);
        super.execute((Runnable)delegatingRunnable);
    }

    public ScheduledFuture<Object> schedule(Runnable task, Trigger trigger) {
        task = this.wrapRunnable(task);
        1 wrappedTrigger = new /* Unavailable Anonymous Inner Class!! */;
        DelegatingRunnable delegatingRunnable = new DelegatingRunnable(this.executorService, task);
        ScheduledFuture future = super.schedule((Runnable)delegatingRunnable, (Trigger)wrappedTrigger);
        return new DelegatingForwardingScheduledFuture(future);
    }

    public ScheduledFuture<Object> schedule(Runnable task, Date startTime) {
        startTime = this.getDelayedStartDate(startTime);
        DelegatingRunnable delegatingRunnable = new DelegatingRunnable(this.executorService, task);
        ScheduledFuture future = super.schedule((Runnable)delegatingRunnable, startTime);
        return new DelegatingForwardingScheduledFuture(future);
    }

    public ScheduledFuture<Object> scheduleAtFixedRate(Runnable task, Date startTime, long period) {
        task = this.wrapRunnable(task);
        startTime = this.getDelayedStartDate(startTime);
        startTime = new Date(startTime.getTime() + period);
        DelegatingRunnable delegatingRunnable = new DelegatingRunnable(this.executorService, task);
        ScheduledFuture future = super.scheduleAtFixedRate((Runnable)delegatingRunnable, startTime, period);
        return new DelegatingForwardingScheduledFuture(future);
    }

    public ScheduledFuture<Object> scheduleAtFixedRate(Runnable task, long period) {
        task = this.wrapRunnable(task);
        long additionalStartDelay = this.getAdditionalStartDelay();
        if (additionalStartDelay > 0L) {
            return this.scheduleAtFixedRate(task, new Date(), period);
        }
        DelegatingRunnable delegatingRunnable = new DelegatingRunnable(this.executorService, task);
        ScheduledFuture future = super.scheduleAtFixedRate((Runnable)delegatingRunnable, period);
        return new DelegatingForwardingScheduledFuture(future);
    }

    public ScheduledFuture<Object> scheduleWithFixedDelay(Runnable task, Date startTime, long delay) {
        task = this.wrapRunnable(task);
        startTime = this.getDelayedStartDate(startTime);
        startTime = new Date(startTime.getTime() + delay);
        DelegatingRunnable delegatingRunnable = new DelegatingRunnable(this.executorService, task);
        ScheduledFuture future = super.scheduleWithFixedDelay((Runnable)delegatingRunnable, startTime, delay);
        return new DelegatingForwardingScheduledFuture(future);
    }

    public ScheduledFuture<Object> scheduleWithFixedDelay(Runnable task, long delay) {
        task = this.wrapRunnable(task);
        long additionalStartDelay = this.getAdditionalStartDelay();
        if (additionalStartDelay > 0L) {
            return this.scheduleWithFixedDelay(task, new Date(), delay);
        }
        DelegatingRunnable delegatingRunnable = new DelegatingRunnable(this.executorService, task);
        ScheduledFuture future = super.scheduleWithFixedDelay((Runnable)delegatingRunnable, delay);
        return new DelegatingForwardingScheduledFuture(future);
    }
}

