/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.threading;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jasig.portal.utils.ConcurrentMapUtils;
import org.jasig.portal.utils.threading.QualityOfServiceBlockingQueue;

public abstract class QualityOfServiceBlockingQueue<K, T>
implements BlockingQueue<T> {
    private final ConcurrentMap<K, Queue<T>> keyedQueues = new ConcurrentHashMap();
    private final Set<K> queueKeySet = Collections.unmodifiableSet(this.keyedQueues.keySet());
    private final int capacity;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private final Condition notEmpty = this.writeLock.newCondition();
    private final Condition notFull = this.writeLock.newCondition();
    private int size = 0;
    private K peekedKey = null;

    public QualityOfServiceBlockingQueue() {
        this.capacity = Integer.MAX_VALUE;
    }

    public QualityOfServiceBlockingQueue(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
    }

    protected abstract K getElementKey(T var1);

    protected abstract K getNextElementKey();

    public final Set<K> getKeySet() {
        return this.queueKeySet;
    }

    public final boolean isKeyEmpty(K key) {
        Queue queue = (Queue)this.keyedQueues.get(key);
        if (queue == null) {
            return true;
        }
        return queue.isEmpty();
    }

    public final int getKeySize(K key) {
        Queue queue = (Queue)this.keyedQueues.get(key);
        if (queue == null) {
            return 0;
        }
        return queue.size();
    }

    @Override
    public final boolean add(T e) {
        return this.add(e, true);
    }

    @Override
    public final boolean offer(T e) {
        return this.add(e, false);
    }

    @Override
    public final void put(T e) throws InterruptedException {
        this.offer(e, -1L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean offer(T e, long timeout, TimeUnit unit) throws InterruptedException {
        Queue queue = this.getOrCreateQueue(e);
        long start = this.getWriteLockWithOptionalWait(timeout, unit);
        if (start == Long.MIN_VALUE) {
            return false;
        }
        long maxWait = start >= 0L ? unit.toMillis(timeout) : -1L;
        try {
            if (!this.waitForRemove(start, maxWait)) {
                boolean bl = false;
                return bl;
            }
            boolean added = queue.add(e);
            if (added) {
                ++this.size;
                this.notEmpty.signal();
            }
            boolean bl = added;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public final T take() throws InterruptedException {
        return (T)this.poll(-1L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T poll(long timeout, TimeUnit unit) throws InterruptedException {
        long start = this.getWriteLockWithOptionalWait(timeout, unit);
        if (start == Long.MIN_VALUE) {
            return null;
        }
        long maxWait = start >= 0L ? unit.toMillis(timeout) : -1L;
        try {
            if (!this.waitForAdd(start, maxWait)) {
                T t = null;
                return t;
            }
            Object object = this.pollInternal(false);
            return (T)object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int remainingCapacity() {
        this.readLock.lock();
        try {
            int n = this.capacity - this.size;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean remove(Object o) {
        if (this.isEmpty()) {
            return false;
        }
        Object key = this.getElementKey(o);
        Queue queue = (Queue)this.keyedQueues.get(key);
        if (queue == null) {
            return false;
        }
        this.writeLock.lock();
        try {
            boolean removed = queue.remove(o);
            if (removed) {
                --this.size;
                this.notFull.signal();
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public final boolean contains(Object o) {
        Object key = this.getElementKey(o);
        Queue queue = (Queue)this.keyedQueues.get(key);
        if (queue == null) {
            return false;
        }
        return queue.contains(o);
    }

    @Override
    public final int drainTo(Collection<? super T> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int drainTo(Collection<? super T> c, int maxElements) {
        if (this.isEmpty()) {
            return 0;
        }
        this.writeLock.lock();
        try {
            int count;
            for (count = 0; count < this.size && count < maxElements; ++count) {
                Object key = this.getNextElementKey();
                Queue queue = (Queue)this.keyedQueues.get(key);
                if (queue == null || queue.isEmpty()) {
                    throw new IllegalStateException("getNextElementKey returned key='" + key + "' but there are no elements available for the key. This violates the contract specified for getNextElementKey: " + this.toString());
                }
                Object e = queue.poll();
                c.add(e);
            }
            this.size -= count;
            if (count > 0) {
                this.notFull.signal();
            }
            int n = count;
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public final T remove() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object e = this.poll();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return (T)e;
    }

    @Override
    public final T poll() {
        if (this.isEmpty()) {
            return null;
        }
        return (T)this.pollInternal(false);
    }

    @Override
    public final T element() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object e = this.peek();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return (T)e;
    }

    @Override
    public final T peek() {
        if (this.isEmpty()) {
            return null;
        }
        return (T)this.pollInternal(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int size() {
        this.readLock.lock();
        try {
            int n = this.size;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final Iterator<T> iterator() {
        return new ElementIterator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object[] toArray() {
        this.readLock.lock();
        try {
            Object[] objectArray = this.toArray(new Object[this.size]);
            return objectArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <AT> AT[] toArray(AT[] a) {
        this.readLock.lock();
        try {
            if (a.length < this.size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
            }
            AT[] result = a;
            int index = 0;
            for (Queue queue : this.keyedQueues.values()) {
                for (Object e : queue) {
                    result[index++] = e;
                }
            }
            if (a.length > this.size) {
                a[this.size] = null;
            }
            Object[] objectArray = a;
            return objectArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public final boolean containsAll(Collection<?> c) {
        int size = this.size();
        if (size == 0 || size < c.size()) {
            return false;
        }
        for (Object o : c) {
            Object key = this.getElementKey(o);
            Queue queue = (Queue)this.keyedQueues.get(key);
            if (queue != null && queue.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean addAll(Collection<? extends T> c) {
        boolean changed = false;
        for (T o : c) {
            changed |= this.add(o);
        }
        return changed;
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            changed |= this.remove(o);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean retainAll(Collection<?> c) {
        this.writeLock.lock();
        try {
            int newSize = 0;
            for (Queue queue : this.keyedQueues.values()) {
                queue.retainAll(c);
                newSize += queue.size();
            }
            int oldSize = this.size;
            this.size = newSize;
            boolean bl = this.size != oldSize;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear() {
        this.writeLock.lock();
        try {
            this.size = 0;
            this.keyedQueues.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean add(T e, boolean failWhenFull) {
        Queue queue = this.getOrCreateQueue(e);
        this.writeLock.lock();
        try {
            if (this.size == this.capacity) {
                if (failWhenFull) {
                    throw new IllegalStateException("Queue is at capacity: " + this.capacity);
                }
                boolean bl = false;
                return bl;
            }
            boolean added = queue.add(e);
            if (added) {
                ++this.size;
                this.notEmpty.signal();
            }
            boolean bl = added;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Queue<T> getOrCreateQueue(T e) {
        Object key = this.getElementKey(e);
        Queue queue = (ConcurrentLinkedQueue)this.keyedQueues.get(key);
        if (queue == null) {
            queue = new ConcurrentLinkedQueue();
            queue = (Queue)ConcurrentMapUtils.putIfAbsent((ConcurrentMap)this.keyedQueues, (Object)key, queue);
        }
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T pollInternal(boolean peek) {
        this.writeLock.lock();
        try {
            Queue queue;
            Object key;
            if (this.size == 0) {
                T t = null;
                return t;
            }
            if (this.peekedKey != null) {
                key = this.peekedKey;
                if (!peek) {
                    this.peekedKey = null;
                }
            } else {
                key = this.getNextElementKey();
                if (peek) {
                    this.peekedKey = key;
                }
            }
            if ((queue = (Queue)this.keyedQueues.get(key)) == null || queue.isEmpty()) {
                throw new IllegalStateException("getNextElementKey returned key='" + key + "' but there are no elements available for the key. This violates the contract specified for getNextElementKey");
            }
            if (peek) {
                Object e = queue.peek();
                return (T)e;
            }
            --this.size;
            this.notFull.signal();
            Object e = queue.poll();
            return (T)e;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean waitForRemove(long waitStart, long maxWait) throws InterruptedException {
        return this.size != this.capacity || this.waitOnCondition(this.notFull, maxWait, waitStart);
    }

    private long getWriteLockWithOptionalWait(long timeout, TimeUnit unit) throws InterruptedException {
        long start;
        if (timeout >= 0L) {
            start = System.currentTimeMillis();
            boolean locked = this.writeLock.tryLock(timeout, unit);
            if (!locked) {
                return Long.MIN_VALUE;
            }
        } else {
            start = -1L;
            this.writeLock.lock();
        }
        return start;
    }

    private boolean waitForAdd(long waitStart, long maxWait) throws InterruptedException {
        while (this.size == 0) {
            if (this.waitOnCondition(this.notEmpty, maxWait, waitStart)) continue;
            return false;
        }
        return true;
    }

    private boolean waitOnCondition(Condition condition, long maxWait, long waitStart) throws InterruptedException {
        if (maxWait >= 0L) {
            long waited = System.currentTimeMillis() - waitStart;
            long waitTime = maxWait - waited;
            if (waitTime <= 0L) {
                return false;
            }
            boolean notified = condition.await(waitTime, TimeUnit.MILLISECONDS);
            if (!notified) {
                return false;
            }
        } else {
            condition.await();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.readLock.lock();
        try {
            StringBuilder str = new StringBuilder(this.size * 50 + 2);
            str.append("{");
            Iterator entryItr = this.keyedQueues.entrySet().iterator();
            while (entryItr.hasNext()) {
                Map.Entry entry = entryItr.next();
                Object key = entry.getKey();
                Queue queue = (Queue)entry.getValue();
                str.append(key).append("=").append(queue.size());
                if (!entryItr.hasNext()) continue;
                str.append(", ");
            }
            str.append("}");
            String string = str.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    static /* synthetic */ ConcurrentMap access$000(QualityOfServiceBlockingQueue x0) {
        return x0.keyedQueues;
    }

    static /* synthetic */ Lock access$100(QualityOfServiceBlockingQueue x0) {
        return x0.writeLock;
    }

    static /* synthetic */ int access$210(QualityOfServiceBlockingQueue x0) {
        return x0.size--;
    }

    static /* synthetic */ Condition access$300(QualityOfServiceBlockingQueue x0) {
        return x0.notFull;
    }
}

