/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class RemoteCookieCheckFilter
implements Filter {
    public static final String COOKIE_NAME = "JSESSIONID";
    public static final String REFERER_ATTRIBUTE = "COOKIE_CHECK_REFERER";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        if (!"POST".equals(httpServletRequest.getMethod())) {
            boolean cookieFound = false;
            Cookie[] cookies = httpServletRequest.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equalsIgnoreCase(COOKIE_NAME)) continue;
                    cookieFound = true;
                    break;
                }
            }
            if (!cookieFound) {
                HttpSession session = httpServletRequest.getSession(true);
                String requestURI = httpServletRequest.getRequestURI();
                String queryString = httpServletRequest.getQueryString();
                if (queryString != null) {
                    requestURI = requestURI + "?" + queryString;
                }
                session.setAttribute(REFERER_ATTRIBUTE, (Object)requestURI);
                String url = httpServletRequest.getContextPath() + "/api" + "/cookiecheck";
                ((HttpServletResponse)response).sendRedirect(url);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

