/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.web.flow;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.springframework.web.servlet.View;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.mvc.builder.DelegatingFlowViewResolver;
import org.springframework.webflow.mvc.view.FlowViewResolver;

public class FallbackDelegatingFlowViewResolver
extends DelegatingFlowViewResolver {
    private final List<FlowViewResolver> flowViewResolvers;

    public FallbackDelegatingFlowViewResolver(List<FlowViewResolver> flowViewResolvers, List viewResolvers) {
        super(viewResolvers);
        this.flowViewResolvers = ImmutableList.copyOf(flowViewResolvers);
    }

    public View resolveView(String viewId, RequestContext context) {
        View view = super.resolveView(viewId, context);
        if (view != null) {
            return view;
        }
        for (FlowViewResolver flowViewResolver : this.flowViewResolvers) {
            try {
                String viewIdByConvention = flowViewResolver.getViewIdByConvention(viewId);
                view = flowViewResolver.resolveView(viewIdByConvention, context);
                if (view == null) continue;
                return view;
            }
            catch (Exception e) {
                IllegalStateException ise = new IllegalStateException("Exception resolving view with name '" + viewId + "'");
                ise.initCause(e);
                throw ise;
            }
        }
        return null;
    }
}

