/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.version;

import java.io.Serializable;
import org.jasig.portal.version.om.Version;

public abstract class AbstractVersion
implements Version,
Serializable {
    private static final long serialVersionUID = 1L;
    private int hashCode = 0;

    public final boolean isBefore(Version other) {
        return this.compareTo(other) < 0;
    }

    public final boolean isAfter(Version other) {
        return this.compareTo(other) > 1;
    }

    public final int compareTo(Version o) {
        Integer ol;
        int diff = this.getMajor() - o.getMajor();
        if (diff > 0) {
            return 1;
        }
        if (diff < 0) {
            return -1;
        }
        diff = this.getMinor() - o.getMinor();
        if (diff > 0) {
            return 1;
        }
        if (diff < 0) {
            return -1;
        }
        diff = this.getPatch() - o.getPatch();
        if (diff > 0) {
            return 1;
        }
        if (diff < 0) {
            return -1;
        }
        Integer l = this.getLocal();
        if (l == (ol = o.getLocal())) {
            return 0;
        }
        if (l == null) {
            return -1;
        }
        if (ol == null) {
            return 1;
        }
        return l.compareTo(ol);
    }

    public final int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            int prime = 31;
            result = 1;
            result = 31 * result + this.getMajor();
            result = 31 * result + this.getMinor();
            result = 31 * result + this.getPatch();
            Integer local = this.getLocal();
            this.hashCode = result = 31 * result + (local == null ? 0 : local.hashCode());
        }
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.hashCode() != this.hashCode()) {
            return false;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        Version other = (Version)obj;
        if (this.getMajor() != other.getMajor()) {
            return false;
        }
        if (this.getMinor() != other.getMinor()) {
            return false;
        }
        if (this.getPatch() != other.getPatch()) {
            return false;
        }
        Integer local = this.getLocal();
        Integer oLocal = other.getLocal();
        return !(local == null ? oLocal != null : !local.equals(oLocal));
    }

    public final String toString() {
        Integer local = this.getLocal();
        if (local == null) {
            return this.getMajor() + "." + this.getMinor() + "." + this.getPatch();
        }
        return this.getMajor() + "." + this.getMinor() + "." + this.getPatch() + "." + local;
    }
}

