/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.version.dao.jpa;

import com.google.common.base.Function;
import java.util.Collection;
import javax.persistence.Parameter;
import javax.persistence.PersistenceException;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.metamodel.Attribute;
import org.hibernate.exception.SQLGrammarException;
import org.jasig.portal.jpa.BaseJpaDao;
import org.jasig.portal.jpa.BasePortalJpaDao;
import org.jasig.portal.jpa.OpenEntityManager;
import org.jasig.portal.version.dao.VersionDao;
import org.jasig.portal.version.dao.jpa.VersionImpl;
import org.jasig.portal.version.dao.jpa.VersionImpl_;
import org.jasig.portal.version.om.Version;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.stereotype.Repository;

@Repository(value="versionDao")
public class JpaVersionDao
extends BasePortalJpaDao
implements VersionDao {
    private CriteriaQuery<Tuple> findCoreVersionNumbers;
    private CriteriaQuery<Integer> findLocalVersionNumber;
    private ParameterExpression<String> productParameter;

    public void afterPropertiesSet() throws Exception {
        this.productParameter = this.createParameterExpression(String.class, "product");
        this.findCoreVersionNumbers = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findLocalVersionNumber = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    @OpenEntityManager(unitName="PortalDb")
    public Version getVersion(String product) {
        BaseJpaDao.NaturalIdQuery query = this.createNaturalIdQuery(VersionImpl.class);
        query.using((Attribute)VersionImpl_.product, (Object)product);
        try {
            return (Version)query.load();
        }
        catch (SQLGrammarException e) {
            return this.getSimpleVersion(product);
        }
    }

    private Version getSimpleVersion(String product) {
        Integer local;
        Tuple coreNumbers;
        try {
            TypedQuery coreNumbersQuery = this.createQuery(this.findCoreVersionNumbers);
            coreNumbersQuery.setParameter((Parameter)this.productParameter, (Object)product);
            coreNumbers = (Tuple)DataAccessUtils.singleResult((Collection)coreNumbersQuery.getResultList());
        }
        catch (SQLGrammarException e) {
            this.logger.warn("UP_VERSION table doesn't exist, returning null for version of " + product);
            return null;
        }
        if (coreNumbers == null) {
            return null;
        }
        Integer major = (Integer)coreNumbers.get(VersionImpl_.major.getName(), VersionImpl_.major.getBindableJavaType());
        Integer minor = (Integer)coreNumbers.get(VersionImpl_.minor.getName(), VersionImpl_.minor.getBindableJavaType());
        Integer patch = (Integer)coreNumbers.get(VersionImpl_.patch.getName(), VersionImpl_.patch.getBindableJavaType());
        try {
            TypedQuery localNumberQuery = this.createQuery(this.findLocalVersionNumber);
            localNumberQuery.setParameter((Parameter)this.productParameter, (Object)product);
            local = (Integer)DataAccessUtils.singleResult((Collection)localNumberQuery.getResultList());
        }
        catch (PersistenceException e) {
            local = null;
        }
        return new VersionImpl(product, major.intValue(), minor.intValue(), patch.intValue(), local);
    }

    @BasePortalJpaDao.PortalTransactional
    public Version setVersion(String product, int major, int minor, int patch, Integer local) {
        BaseJpaDao.NaturalIdQuery query = this.createNaturalIdQuery(VersionImpl.class);
        query.using((Attribute)VersionImpl_.product, (Object)product);
        VersionImpl version = (VersionImpl)query.load();
        if (version == null) {
            version = new VersionImpl(product, major, minor, patch, local);
        } else {
            version.setMajor(major);
            version.setMinor(minor);
            version.setPatch(patch);
            version.setLocal(local);
        }
        this.getEntityManager().persist((Object)version);
        return version;
    }

    @BasePortalJpaDao.PortalTransactional
    public Version setVersion(String product, Version version) {
        return this.setVersion(product, version.getMajor(), version.getMinor(), version.getPatch(), version.getLocal());
    }

    static /* synthetic */ ParameterExpression access$000(JpaVersionDao x0) {
        return x0.productParameter;
    }
}

