/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionLoggingFilter
implements Filter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        }
        catch (Throwable t) {
            StringBuilder msg = new StringBuilder();
            if (request instanceof HttpServletRequest) {
                HttpServletRequest req = (HttpServletRequest)request;
                msg.append("for URL=" + req.getRequestURI());
                if (StringUtils.isNotBlank((String)req.getQueryString())) {
                    msg.append("?" + req.getQueryString());
                }
                msg.append(", user=" + req.getRemoteUser());
                msg.append(" ");
            }
            msg.append(", from IP=" + request.getRemoteAddr());
            this.logger.error("uPortal: unhandled exception '" + t.getMessage() + "' " + msg.toString(), t);
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new ServletException(t);
        }
    }
}

