/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.xml.stream;

import java.io.StringWriter;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jasig.portal.character.stream.CharacterEventSource;
import org.jasig.portal.character.stream.events.CharacterDataEventImpl;
import org.jasig.portal.character.stream.events.CharacterEvent;
import org.jasig.portal.xml.stream.BaseXMLEventReader;

public class ChunkingEventReader
extends BaseXMLEventReader {
    private static final XMLEventFactory EVENT_FACTORY = XMLEventFactory.newFactory();
    private final List<CharacterEvent> characterEvents = new LinkedList();
    private final HttpServletRequest request;
    private final Map<String, CharacterEventSource> chunkingElements;
    private final Map<Pattern, CharacterEventSource> chunkingPatternEventSources;
    private final Pattern[] chunkingPatterns;
    private final XMLEventWriter xmlEventWriter;
    private final StringWriter writer;
    private boolean removeXmlDeclaration = true;
    private XMLEvent peekedEvent = null;
    private StartElement captureEvent = null;

    public ChunkingEventReader(HttpServletRequest request, Map<String, CharacterEventSource> chunkingElements, Map<Pattern, CharacterEventSource> chunkingPatternEventSources, Pattern[] chunkingPatterns, XMLEventReader xmlEventReader, XMLEventWriter xmlEventWriter, StringWriter writer) {
        super(xmlEventReader);
        this.request = request;
        this.chunkingElements = chunkingElements;
        this.chunkingPatternEventSources = chunkingPatternEventSources;
        this.chunkingPatterns = chunkingPatterns;
        this.xmlEventWriter = xmlEventWriter;
        this.writer = writer;
    }

    public boolean isRemoveXmlDeclaration() {
        return this.removeXmlDeclaration;
    }

    public void setRemoveXmlDeclaration(boolean removeXmlDeclaration) {
        this.removeXmlDeclaration = removeXmlDeclaration;
    }

    public List<CharacterEvent> getCharacterEvents() {
        return this.characterEvents;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public XMLEvent peek() throws XMLStreamException {
        if (this.peekedEvent == null) {
            this.peekedEvent = this.nextEvent();
        }
        return this.peekedEvent;
    }

    protected XMLEvent internalNextEvent() throws XMLStreamException {
        XMLEvent event = null;
        if (this.peekedEvent != null) {
            event = this.peekedEvent;
            this.peekedEvent = null;
            return event;
        }
        XMLEvent previousEvent = this.getPreviousEvent();
        if (previousEvent != null && previousEvent.isStartDocument()) {
            this.xmlEventWriter.flush();
            this.clearWriter();
        }
        if (this.captureEvent != null) {
            event = this.tryChunking(this.captureEvent);
            this.captureEvent = null;
        } else {
            event = this.getParent().nextEvent();
            if (event.isStartElement()) {
                StartElement startElement = event.asStartElement();
                event = this.tryChunking(startElement);
            }
        }
        return event;
    }

    private XMLEvent tryChunking(StartElement startElement) throws XMLStreamException {
        QName elementName = startElement.getName();
        CharacterEventSource characterEventSource = (CharacterEventSource)this.chunkingElements.get(elementName.getLocalPart());
        while (characterEventSource != null) {
            XMLEvent previousEvent = this.getPreviousEvent();
            if (previousEvent != null && previousEvent.isStartElement()) {
                this.captureEvent = startElement;
                return EVENT_FACTORY.createCharacters("");
            }
            this.captureCharacterDataEvent();
            XMLEventReader parent = this.getParent();
            characterEventSource.generateCharacterEvents(this.request, parent, startElement, (Collection)this.characterEvents);
            XMLEvent nextEvent = parent.nextEvent();
            if (nextEvent.isStartElement()) {
                startElement = nextEvent.asStartElement();
                elementName = startElement.getName();
                characterEventSource = (CharacterEventSource)this.chunkingElements.get(elementName.getLocalPart());
                continue;
            }
            return nextEvent;
        }
        return startElement;
    }

    protected void captureCharacterDataEvent() throws XMLStreamException {
        this.xmlEventWriter.flush();
        this.chunkString(this.characterEvents, (CharSequence)this.writer.toString(), 0);
        this.clearWriter();
    }

    private void clearWriter() {
        StringBuffer buffer = this.writer.getBuffer();
        buffer.delete(0, buffer.length());
    }

    protected void chunkString(List<CharacterEvent> characterEvents, CharSequence buffer, int patternIndex) {
        while (patternIndex < this.chunkingPatterns.length) {
            Pattern pattern = this.chunkingPatterns[patternIndex];
            Matcher matcher = pattern.matcher(buffer);
            if (matcher.find()) {
                CharacterEventSource eventSource = (CharacterEventSource)this.chunkingPatternEventSources.get(pattern);
                int prevMatchEnd = 0;
                do {
                    this.chunkString(characterEvents, buffer.subSequence(prevMatchEnd, matcher.start()), patternIndex + 1);
                    MatchResult matchResult = matcher.toMatchResult();
                    eventSource.generateCharacterEvents(this.request, matchResult, characterEvents);
                    prevMatchEnd = matcher.end();
                } while (matcher.find());
                if (prevMatchEnd < buffer.length()) {
                    this.chunkString(characterEvents, buffer.subSequence(prevMatchEnd, buffer.length()), patternIndex + 1);
                }
                return;
            }
            ++patternIndex;
        }
        String eventString = buffer.toString();
        characterEvents.add((CharacterEvent)CharacterDataEventImpl.create((String)eventString));
    }

    public boolean hasNext() {
        if (this.peekedEvent != null) {
            return true;
        }
        if (!this.getParent().hasNext()) {
            return false;
        }
        try {
            this.peekedEvent = this.nextEvent();
        }
        catch (NoSuchElementException e) {
            return false;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public void close() throws XMLStreamException {
        this.captureCharacterDataEvent();
        this.getParent().close();
    }
}

