/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.xml.stream;

import java.util.Deque;
import java.util.LinkedList;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.jasig.portal.xml.stream.BaseXMLEventReader;

public abstract class InjectingXMLEventReader
extends BaseXMLEventReader {
    private Deque<XMLEvent> additionalEvents;

    public InjectingXMLEventReader(XMLEventReader reader) {
        super(reader);
    }

    protected final XMLEvent internalNextEvent() throws XMLStreamException {
        if (this.additionalEvents != null && !this.additionalEvents.isEmpty()) {
            return (XMLEvent)this.additionalEvents.pop();
        }
        XMLEvent event = this.getParent().nextEvent();
        this.additionalEvents = this.getAdditionalEvents(event);
        if (this.additionalEvents != null) {
            this.additionalEvents.offer(event);
            return (XMLEvent)this.additionalEvents.pop();
        }
        return event;
    }

    public final XMLEvent peek() throws XMLStreamException {
        if (this.additionalEvents != null && !this.additionalEvents.isEmpty()) {
            return (XMLEvent)this.additionalEvents.peek();
        }
        XMLEvent event = this.getParent().peek();
        XMLEvent peekEvent = this.getPeekEvent(event);
        if (peekEvent != null) {
            return peekEvent;
        }
        return event;
    }

    public boolean hasNext() {
        return super.hasNext() || this.additionalEvents != null && !this.additionalEvents.isEmpty();
    }

    protected Deque<XMLEvent> getAdditionalEvents(XMLEvent event) {
        XMLEvent additionalEvent = this.getAdditionalEvent(event);
        if (additionalEvent == null) {
            return null;
        }
        LinkedList<XMLEvent> additionalEvents = new LinkedList<XMLEvent>();
        additionalEvents.push(additionalEvent);
        return additionalEvents;
    }

    protected XMLEvent getAdditionalEvent(XMLEvent event) {
        throw new UnsupportedOperationException("Either 'Deque<XMLEvent> getAdditionalEvents(XMLEvent event)' or 'XMLEvent getAdditionalEvent(XMLEvent event must be implemented");
    }

    protected abstract XMLEvent getPeekEvent(XMLEvent var1);
}

