/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.xml.stream;

import java.util.ListIterator;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.XMLEvent;
import org.jasig.portal.xml.stream.XMLStreamConstantsUtils;

public class XMLEventBufferReader
implements XMLEventReader {
    private final ListIterator<XMLEvent> eventBuffer;
    private XMLEvent previousEvent;

    public XMLEventBufferReader(ListIterator<XMLEvent> eventBuffer) {
        this.eventBuffer = eventBuffer;
    }

    @Override
    public void close() {
    }

    @Override
    public XMLEvent peek() {
        XMLEvent event = (XMLEvent)this.eventBuffer.next();
        this.eventBuffer.previous();
        return event;
    }

    @Override
    public boolean hasNext() {
        return this.eventBuffer.hasNext();
    }

    @Override
    public XMLEvent next() {
        this.previousEvent = (XMLEvent)this.eventBuffer.next();
        return this.previousEvent;
    }

    @Override
    public void remove() {
        this.eventBuffer.remove();
    }

    @Override
    public String getElementText() throws XMLStreamException {
        XMLEvent event = this.previousEvent;
        if (event == null) {
            throw new XMLStreamException("Must be on START_ELEMENT to read next text, element was null");
        }
        if (!event.isStartElement()) {
            throw new XMLStreamException("Must be on START_ELEMENT to read next text", event.getLocation());
        }
        StringBuilder text = new StringBuilder();
        while (!event.isEndDocument()) {
            switch (event.getEventType()) {
                case 4: 
                case 6: 
                case 12: {
                    Characters characters = event.asCharacters();
                    text.append(characters.getData());
                    break;
                }
                case 9: {
                    EntityReference entityReference = (EntityReference)event;
                    EntityDeclaration declaration = entityReference.getDeclaration();
                    text.append(declaration.getReplacementText());
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                default: {
                    throw new XMLStreamException("Unexpected event type '" + XMLStreamConstantsUtils.getEventName((int)event.getEventType()) + "' encountered. Found event: " + event, event.getLocation());
                }
            }
            event = this.nextEvent();
        }
        return text.toString();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return null;
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        return this.next();
    }

    @Override
    public XMLEvent nextTag() throws XMLStreamException {
        XMLEvent event = this.nextEvent();
        while (event.isCharacters() && event.asCharacters().isWhiteSpace() || event.isProcessingInstruction() || event.getEventType() == 5) {
            event = this.nextEvent();
        }
        if (!event.isStartElement() && event.isEndElement()) {
            throw new XMLStreamException("Unexpected event type '" + XMLStreamConstantsUtils.getEventName((int)event.getEventType()) + "' encountered. Found event: " + event, event.getLocation());
        }
        return event;
    }
}

