/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.announcements.controller;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.portlet.PortletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portlet.announcements.model.Announcement;
import org.jasig.portlet.announcements.model.Topic;
import org.jasig.portlet.announcements.service.IAnnouncementService;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class RssFeedController
extends AbstractController {
    private IAnnouncementService announcementService;
    private static final String CONTENT_TYPE = "application/rss+xml";

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws IllegalStateException, IOException {
        String out;
        Long topicId;
        response.setContentType(CONTENT_TYPE);
        try {
            topicId = (long)ServletRequestUtils.getIntParameter((ServletRequest)request, (String)"topic");
            if (topicId == null) {
                throw new IllegalStateException("Must specify the topic id");
            }
        }
        catch (Exception e) {
            response.sendError(400, "Must specify topic id");
            return null;
        }
        Topic t = null;
        try {
            t = this.announcementService.getTopic(topicId);
        }
        catch (PortletException e) {
            e.printStackTrace();
        }
        if (t == null) {
            response.sendError(404, "no such topic");
            return null;
        }
        if (!t.isAllowRss()) {
            response.sendError(403, "This topic is not available as RSS");
            return null;
        }
        ArrayList announcements = new ArrayList();
        announcements.addAll(t.getPublishedAnnouncements());
        Collections.sort(announcements);
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType("rss_2.0");
        feed.setTitle(t.getTitle());
        feed.setLink(request.getRequestURL().append("?topic=").append(topicId.toString()).toString());
        feed.setDescription(t.getDescription());
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        for (Announcement a : announcements) {
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setTitle(a.getTitle());
            entry.setAuthor(a.getAuthor());
            if (a.getLink() != null) {
                entry.setLink(a.getLink());
            }
            entry.setPublishedDate(a.getStartDisplay());
            SyndContentImpl description = new SyndContentImpl();
            description.setType("text/plain");
            description.setValue(a.getMessage());
            entry.setDescription((SyndContent)description);
            entries.add(entry);
        }
        feed.setEntries(entries);
        SyndFeedOutput output = new SyndFeedOutput();
        try {
            out = output.outputString((SyndFeed)feed);
        }
        catch (FeedException e) {
            e.printStackTrace();
            response.sendError(500, "Error generating feed");
            return null;
        }
        response.setContentLength(out.length());
        response.getOutputStream().print(out);
        response.getOutputStream().flush();
        return null;
    }

    public void setAnnouncementService(IAnnouncementService announcementService) {
        this.announcementService = announcementService;
    }
}

