/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.weather.portlet;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.weather.domain.Weather;
import org.jasig.portlet.weather.service.IWeatherService;
import org.jasig.portlet.weather.service.SavedLocation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;

@Controller
public class WeatherViewController {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IWeatherService weatherService = null;

    @Autowired
    public void setWeatherService(IWeatherService weatherService) {
        this.weatherService = weatherService;
    }

    @RequestMapping(value={"VIEW"})
    public ModelAndView viewWeather(RenderRequest request, RenderResponse response) {
        PortletPreferences prefs = request.getPreferences();
        List savedLocations = this.weatherService.getSavedLocations(prefs);
        ArrayList<Weather> weatherList = new ArrayList<Weather>(savedLocations.size());
        ArrayList<SavedLocation> errorList = new ArrayList<SavedLocation>(savedLocations.size());
        for (SavedLocation savedLocation : savedLocations) {
            try {
                Weather weather = this.weatherService.getWeather(savedLocation.code, savedLocation.temperatureUnit);
                weatherList.add(weather);
            }
            catch (RuntimeException re) {
                errorList.add(savedLocation);
                this.logger.warn((Object)("Failed to load weather for " + savedLocation), (Throwable)re);
            }
        }
        LinkedHashMap<String, ArrayList<Object>> model = new LinkedHashMap<String, ArrayList<Object>>();
        model.put("weathers", weatherList);
        model.put("errors", errorList);
        return new ModelAndView("view", model);
    }
}

