/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.weather.portlet.interceptor;

import java.util.Enumeration;
import javax.portlet.PortletConfig;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.log4j.Logger;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.handler.HandlerInterceptorAdapter;

public class AddInitParamsInterceptor
extends HandlerInterceptorAdapter
implements PortletConfigAware {
    private PortletConfig portletConfig;
    private Logger log = Logger.getLogger(this.getClass());
    private String modelPrefix = "model:";

    public void postHandleRender(RenderRequest request, RenderResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        Enumeration initNames = this.portletConfig.getInitParameterNames();
        while (initNames.hasMoreElements()) {
            String initParamName = (String)initNames.nextElement();
            if (!initParamName.startsWith(this.modelPrefix)) continue;
            String initParamValue = this.portletConfig.getInitParameter(initParamName);
            initParamName = initParamName.replace(this.modelPrefix, "");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Adding init-param [" + initParamName + ":" + initParamValue + "] to model"));
            }
            modelAndView.addObject(initParamName, (Object)initParamValue);
        }
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    public void setModelPrefix(String modelPrefix) {
        this.modelPrefix = modelPrefix;
    }
}

