/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.config;

import edu.wisc.my.webproxy.beans.config.ConfigUtils;
import edu.wisc.my.webproxy.beans.config.ConfigurationException;
import edu.wisc.my.webproxy.beans.config.JspConfigPage;
import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;

public class CacheConfigImpl
extends JspConfigPage {
    private static final String CACHE_PREF_PREFIX = "webproxy.cache.";
    public static final String USE_CACHE = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.cache.").append("useCache").toString();
    public static final String CACHE_TIMEOUT = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.cache.").append("cacheTimeOut").toString();
    public static final String USE_EXPIRED = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.cache.").append("useExpired").toString();
    public static final String RETRY_DELAY = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.cache.").append("retryDelay").toString();
    public static final String PERSIST_CACHE = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.cache.").append("persistCache").toString();
    public static final String CACHE_SCOPE = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.cache.").append("cacheScope").toString();
    public static final String CACHE_SCOPE_USER = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.cache.").append("user").toString();
    public static final String CACHE_SCOPE_APP = new StringBuffer("edu.wisc.my.webproxy.").append("webproxy.cache.").append("application").toString();

    public String getName() {
        return "Cache Configuration";
    }

    public void process(ActionRequest request, ActionResponse response) throws PortletException, IOException, ConfigurationException {
        StringBuffer errorMessages = new StringBuffer();
        PortletPreferences prefs = request.getPreferences();
        Boolean useCache = new Boolean(request.getParameter(USE_CACHE));
        prefs.setValue(USE_CACHE, useCache.toString());
        String cacheScope = null;
        cacheScope = ConfigUtils.checkEmptyNullString((String)request.getParameter(CACHE_SCOPE), (String)CACHE_SCOPE_USER);
        prefs.setValue(CACHE_SCOPE, cacheScope);
        String cacheTimeoutStr = null;
        Integer cacheTimeout = null;
        try {
            cacheTimeoutStr = ConfigUtils.checkEmptyNullString((String)request.getParameter(CACHE_TIMEOUT), null);
            if (cacheTimeoutStr != null) {
                cacheTimeout = new Integer(cacheTimeoutStr);
                prefs.setValue(CACHE_TIMEOUT, cacheTimeout.toString());
            } else {
                prefs.setValue(CACHE_TIMEOUT, "");
            }
        }
        catch (NumberFormatException nfe) {
            errorMessages.append("Invalid cache timeout specified '").append(cacheTimeoutStr).append("'\n");
        }
        Boolean useExpired = new Boolean(request.getParameter(USE_EXPIRED));
        prefs.setValue(USE_EXPIRED, useExpired.toString());
        String retryDelayStr = null;
        Integer retryDelay = null;
        try {
            retryDelayStr = ConfigUtils.checkEmptyNullString((String)request.getParameter(RETRY_DELAY), null);
            if (retryDelayStr != null) {
                retryDelay = new Integer(retryDelayStr);
                prefs.setValue(RETRY_DELAY, retryDelay.toString());
            } else {
                prefs.setValue(RETRY_DELAY, "");
            }
        }
        catch (NumberFormatException nfe) {
            errorMessages.append("Invalid retry delay specified '").append(retryDelayStr).append("'\n");
        }
        Boolean persistCache = new Boolean(request.getParameter(PERSIST_CACHE));
        prefs.setValue(PERSIST_CACHE, persistCache.toString());
        if (errorMessages.length() > 0) {
            throw new ConfigurationException(errorMessages.toString());
        }
        prefs.store();
    }
}

