/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.my.webproxy.beans.http;

import edu.wisc.my.webproxy.beans.http.IKeyManager;
import java.io.IOException;
import java.security.SecureRandom;
import javax.portlet.ActionRequest;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.portlet.util.PortletUtils;

public class KeyManager
implements IKeyManager {
    private static final int KEY_SIZE = 129;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final SecureRandom random = new SecureRandom();

    public String generateCacheKey(String pageUrl, PortletRequest request) {
        String instanceKey = this.getInstanceKey(request);
        return this.generateCacheKey(pageUrl, instanceKey);
    }

    public String generateCacheKey(String pageUrl, String instanceKey) {
        StringBuffer cacheKeyBuf = new StringBuffer();
        cacheKeyBuf.append(instanceKey);
        cacheKeyBuf.append(".");
        cacheKeyBuf.append(pageUrl);
        return cacheKeyBuf.toString();
    }

    public String generateStateKey(String key, PortletRequest request) {
        String instanceKey = this.getInstanceKey(request);
        StringBuilder cacheKeyBuf = new StringBuilder();
        cacheKeyBuf.append(instanceKey);
        cacheKeyBuf.append(".");
        cacheKeyBuf.append(key);
        return cacheKeyBuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInstanceKey(PortletRequest request) {
        PortletSession portletSession = request.getPortletSession();
        Object object = PortletUtils.getSessionMutex((PortletSession)portletSession);
        synchronized (object) {
            PortletPreferences preferences = request.getPreferences();
            String instanceKey = preferences.getValue(PORTLET_INSTANCE_KEY, null);
            if (instanceKey == null) {
                instanceKey = (String)portletSession.getAttribute(PORTLET_INSTANCE_KEY);
                if (instanceKey == null) {
                    byte[] keyBytes = new byte[129];
                    this.random.nextBytes(keyBytes);
                    instanceKey = new String(Base64.encodeBase64((byte[])keyBytes));
                    portletSession.setAttribute(PORTLET_INSTANCE_KEY, (Object)instanceKey);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Created new portlet instance key: " + instanceKey));
                    }
                }
                if (request instanceof ActionRequest) {
                    try {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Stored portlet instance key in portlet preferences: " + instanceKey));
                        }
                        preferences.setValue(PORTLET_INSTANCE_KEY, instanceKey);
                        preferences.store();
                    }
                    catch (ReadOnlyException e) {
                        throw new RuntimeException("The portlet preference " + PORTLET_INSTANCE_KEY + " must not be set read-only", e);
                    }
                    catch (ValidatorException e) {
                        throw new RuntimeException("The portlet preference " + PORTLET_INSTANCE_KEY + " failed storage validation", e);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Storing the portlet preference " + PORTLET_INSTANCE_KEY + " failed", e);
                    }
                }
            }
            return instanceKey;
        }
    }
}

