/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.emailpreview.dao.exchange;

import javax.mail.Folder;
import javax.portlet.PortletRequest;
import org.jasig.portlet.emailpreview.AccountSummary;
import org.jasig.portlet.emailpreview.EmailMessage;
import org.jasig.portlet.emailpreview.EmailPreviewException;
import org.jasig.portlet.emailpreview.MailStoreConfiguration;
import org.jasig.portlet.emailpreview.dao.IEmailAccountService;
import org.jasig.portlet.emailpreview.dao.exchange.IExchangeAccountDao;
import org.jasig.portlet.emailpreview.dao.exchange.IExchangeCredentialsService;
import org.jasig.portlet.emailpreview.service.IServiceBroker;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationService;
import org.jasig.portlet.emailpreview.service.auth.IAuthenticationServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ExchangeAccountService
implements IEmailAccountService {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired(required=true)
    private IAuthenticationServiceRegistry authServiceRegistry;
    @Autowired(required=true)
    private IServiceBroker serviceBroker;
    @Autowired
    private IExchangeAccountDao dao;
    @Autowired
    private IExchangeCredentialsService exchangeCredentialsService;

    public void setExchangeCredentialsService(IExchangeCredentialsService exchangeCredentialsService) {
        this.exchangeCredentialsService = exchangeCredentialsService;
    }

    public AccountSummary getAccountSummary(PortletRequest req, int start, int max, boolean refresh, String folder) throws EmailPreviewException {
        AccountSummary rslt;
        String username = req.getRemoteUser();
        if (username == null) {
            throw new EmailPreviewException("Anonymous access is not supported");
        }
        MailStoreConfiguration config = this.setupMailStoreConfig(req);
        config.setInboxFolderName(folder);
        String mailAccount = config.getMailAccount();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Account summary requested for " + username + ", folder=" + folder + ", start=" + start + " max=" + max + " refresh=" + refresh);
        }
        if (refresh) {
            this.dao.clearAccountSummaryCache(username, mailAccount);
        }
        if ((rslt = this.dao.fetchAccountSummaryFromStore(config, username, mailAccount, start, max, folder)).getMessagesStart() != start || rslt.getMessagesMax() != max) {
            if (this.log.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Clearing AccountSummary cache for username '").append(username).append("', mailAccount '").append(mailAccount).append("':  start=[").append(rslt.getMessagesStart()).append(" prev, ").append(start).append(" current] ").append("count=[").append(rslt.getMessagesMax()).append(" prev, ").append(max).append(" current]");
                this.log.debug(msg.toString());
            }
            this.dao.clearAccountSummaryCache(username, mailAccount);
            rslt = this.dao.fetchAccountSummaryFromStore(config, username, mailAccount, start, max, folder);
        }
        return rslt;
    }

    private IAuthenticationService populateCredentials(PortletRequest req, MailStoreConfiguration config) {
        IAuthenticationService authService = this.authServiceRegistry.getAuthenticationService(config.getAuthenticationServiceKey());
        if (authService == null) {
            String msg = "Unrecognized authentication service:  " + config.getAuthenticationServiceKey();
            this.log.error(msg);
            throw new EmailPreviewException(msg);
        }
        this.exchangeCredentialsService.initialize(req, config, authService);
        return authService;
    }

    private MailStoreConfiguration setupMailStoreConfig(PortletRequest req) {
        MailStoreConfiguration config = this.serviceBroker.getConfiguration(req);
        IAuthenticationService authService = this.populateCredentials(req, config);
        String mailAccount = authService.getMailAccountName(req, config);
        config.setMailAccount(mailAccount);
        return config;
    }

    public EmailMessage getMessage(PortletRequest req, String messageId) {
        MailStoreConfiguration config = this.setupMailStoreConfig(req);
        if (config.getMarkMessagesAsRead()) {
            this.setSeenFlag(req, new String[]{messageId}, true);
            this.dao.clearAccountSummaryCache(req.getRemoteUser(), config.getMailAccount());
        }
        return this.dao.getMessage(config, messageId);
    }

    public boolean deleteMessages(PortletRequest req, String[] messageIds) {
        MailStoreConfiguration config = this.setupMailStoreConfig(req);
        this.dao.deleteMessages(config, messageIds);
        return true;
    }

    public boolean setSeenFlag(PortletRequest req, String[] messageIds, boolean read) {
        MailStoreConfiguration config = this.setupMailStoreConfig(req);
        this.dao.setMessageReadStatus(config, messageIds, read);
        return true;
    }

    public Folder[] getAllUserInboxFolders(PortletRequest req) {
        MailStoreConfiguration config = this.setupMailStoreConfig(req);
        return this.dao.getAllUserInboxFolders(config).toArray(new Folder[0]);
    }
}

