/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.search.mvc;

import java.util.HashMap;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.search.ldap.LdapSearchServiceImpl;
import org.jasig.web.service.AjaxPortletSupportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ldap.LimitExceededException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class PersonSearchController {
    private static Log log = LogFactory.getLog(PersonSearchController.class);
    private AjaxPortletSupportService ajaxPortletSupportService;
    private LdapSearchServiceImpl personSearchService;

    @RequestMapping(params={"action=personSearch"})
    public void searchPersonDirectory(ActionRequest request, ActionResponse response) throws Exception {
        List people;
        HashMap<String, Object> model;
        block2: {
            model = new HashMap<String, Object>();
            people = null;
            try {
                people = this.personSearchService.searchDirectory(request.getParameter("name"), (PortletRequest)request);
            }
            catch (LimitExceededException e) {
                model.put("sizeLimitExceeded", true);
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)("LDAP search size limit exceeded for search '" + request.getParameter("name") + "'"));
            }
        }
        model.put("people", people);
        model.put("attributes", this.personSearchService.getAttributeTypeMap());
        this.ajaxPortletSupportService.redirectAjaxResponse("ajax/directory", model, request, response);
    }

    @Autowired(required=true)
    public void setAjaxPortletSupportService(AjaxPortletSupportService ajaxPortletSupportService) {
        this.ajaxPortletSupportService = ajaxPortletSupportService;
    }

    @Autowired(required=true)
    public void setPersonSearchService(LdapSearchServiceImpl searchService) {
        this.personSearchService = searchService;
    }
}

