/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.search.mvc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import org.jasig.portlet.search.mvc.ConfiguredSearch;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
@RequestMapping(value={"VIEW"})
public class TabbedSearchController {
    private List<String> gsaSearchEngines;
    private List<ConfiguredSearch> configuredSearches;

    @RequestMapping
    public ModelAndView getSearchView(RenderRequest request) {
        HashMap<String, List> model = new HashMap<String, List>();
        PortletSession session = request.getPortletSession();
        if (request.getRemoteUser() != null) {
            session.setAttribute("loggedIn", (Object)true, 1);
        }
        ArrayList<ConfiguredSearch> allowedSearches = new ArrayList<ConfiguredSearch>();
        block0: for (ConfiguredSearch search : this.configuredSearches) {
            for (String role : search.getRoles()) {
                if (!request.isUserInRole(role)) continue;
                allowedSearches.add(search);
                continue block0;
            }
        }
        session.setAttribute("allowedSearches", allowedSearches, 1);
        model.put("configuredSearches", allowedSearches);
        model.put("gsaSearchEngines", this.gsaSearchEngines);
        return new ModelAndView("/index", "model", model);
    }

    @Resource(name="gsaSearchEngines")
    public void setGsaSearchEngines(List<String> gsaSearchEngines) {
        this.gsaSearchEngines = gsaSearchEngines;
    }

    @Resource(name="configuredSearches")
    @Required
    public void setConfiguredSearches(List<ConfiguredSearch> configuredSearches) {
        this.configuredSearches = configuredSearches;
    }
}

