<%--

    Licensed to Jasig under one or more contributor license
    agreements. See the NOTICE file distributed with this work
    for additional information regarding copyright ownership.
    Jasig licenses this file to you under the Apache License,
    Version 2.0 (the "License"); you may not use this file
    except in compliance with the License. You may obtain a
    copy of the License at:

    http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on
    an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied. See the License for the
    specific language governing permissions and limitations
    under the License.

--%>
<jsp:directive.include file="/WEB-INF/jsp/include.jsp"/>
<portlet:defineObjects/>
<c:set var="n"><portlet:namespace/></c:set>

<link rel="stylesheet" href="<c:url value="/css/tabbed-search.css"/>" type="text/css"></link>
<script src="<rs:resourceURL value="/rs/jquery/1.3.2/jquery-1.3.2.min.js"/>" type="text/javascript"></script>
<script src="<rs:resourceURL value="/rs/jqueryui/1.7.2/jquery-ui-1.7.2.min.js"/>" type="text/javascript"></script>

<script type="text/javascript">
    //<![CDATA[

	var gsaSearchUrl = '<c:url value="/gsaSearch"/>';
	var personSearchUrl = '<portlet:actionURL><portlet:param name="action" value="personSearch"/></portlet:actionURL>';
	var googleFrameUrl = '<c:url value="/googleSearch"/>';

    //]]>
</script>

<style type="text/css">
    .search-container input.search-input { width:90%; max-width:400px; }
</style>

<div id="${n}searchPortletTabs" class="ui-tabs ui-widget ui-widget-content ui-corner-all search-container">
	<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
		<c:forEach items="${ model.configuredSearches }" var="search" varStatus="status">
			<li class="ui-state-default ui-corner-top ${ status.index == 0 ? ' ui-tabs-selected ui-state-active' : '' }"><a shape="rect" href="#search-tab-button-${ search.name }">
				<span><spring:message code="search.${ search.name }.name"/></span></a>
			</li>
		</c:forEach>
	</ul>
	<c:forEach items="${ model.configuredSearches }" var="search" varStatus="status">
		<div id="search-tab-button-${ search.name }" class="ui-tabs-panel ui-widget-content ui-corner-bottom${ status.index != 0 ? ' ui-tabs-hide' : ''  }">
			<jsp:include page="/WEB-INF/jsp/${search.name}.jsp"/>
		</div>
	</c:forEach>
</div>

<script type="text/javascript">
var ${n} = ${n} || {};
${n}.jQuery = jQuery.noConflict(true);
${n}.jQuery(function(){
    var $ = ${n}.jQuery;
	$(document).ready(function(){
		$("#${n}searchPortletTabs").tabs();
		$("#${n}gsaSearchForm").submit(function(){ return searchCampusWeb(this); });
        $("#${n}googleSearchForm").submit(function(){ return searchGoogleFrame(this); });
        $("#${n}directorySearchForm").submit(function(){ return searchPersonDirectory(this); });
	});

	var googleSearchInitialized = false;
	var campusSearchInitialized = false;
	
	var addGoogleStylesheet = function() {
	    // Add CSS style sheets to the page.  We do this through JavaScript because
	    // the portal can't add <link/>s added in the head.
	    if(document.createStyleSheet) {
	        document.createStyleSheet('https://www.google.com/uds/css/gsearch.css');
	    } else {
	        var styles = "@import url(' https://www.google.com/uds/css/gsearch.css ');";
	        var newSS=document.createElement('link');
	        newSS.rel='stylesheet';
	        newSS.href='data:text/css,'+escape(styles);
	        document.getElementsByTagName("head")[0].appendChild(newSS);
	    }
	}
	
	var searchCampusWeb = function(form) {
	    if (!campusSearchInitialized) {
	        campusSearchInitialized = true;
	        addGoogleStylesheet();
	    }
	    var searchDiv = $("#${n}campusWebResults");
	    var params = {q: form.searchtext.value, num: 4};
	    if (form.engine != undefined)
	        params.site = form.engine.value;
         
	    $.get(gsaSearchUrl, 
	        params,
	        function(xml){
	            searchDiv.html(xml);
	        }, "text"
	    );
	    
	    return false;
	}
	   
	var useGsaSuggestion = function(suggestion) {
	    console.debug(suggestion);
	    var form = $("#${n}gsaSearchForm").get(0);
	    form.searchtext.value = $(suggestion).text();
	    return searchCampusWeb(form);
	}
	   
	var searchPersonDirectory = function(form) {
	    $.post(personSearchUrl, 
	        { name: form.searchtext.value }, 
	        function(xml){
	            $("#${n}directoryResults").html(xml);
	            $("#${n}directoryResults .ldapPersonLink")
	               .click(function(){ toggleLdapPerson(this.parentNode) });
	            $("#${n}directoryResults").find("a.vcard-link").click(function(){
                    var attrs = people[$(this).attr("personIndex")].attributes;
                    var form = $("#${n}vCardDownloadForm").html("");
                    for (key in attrs) {
                        form.append($(document.createElement("input")).attr("name", key).val(attrs[key]));
                    }
                    $("#${n}vCardDownloadForm").submit();
		        });
	        }
	    );
	    return false;
	}
	
	var toggleLdapPerson = function(div) {
	    if (div.className == 'inactiveLdapPerson') {
	        div.className = 'activeLdapPerson';
	    } else {
	        div.className = 'inactiveLdapPerson';
	    }
	    return false;
	}
	
	var searchGoogleFrame = function(form) {
	    var searchtype = form.engine.value;
	    var query = form.searchtext.value;
	    var frame = $("#${n}googleFrame");
	    if (!googleSearchInitialized) {
	        frame.attr("src", googleFrameUrl + "?searchtype=" + searchtype + "&query=" + query);
	        googleSearchInitialized = true;
	    } else
	        window.frames.googleFrame.searchGoogle(searchtype, query);
	    frame.css("display", "block");
	    return false;
	}
	
});

var calcGoogleSearchHeight = function() {
    //find the height of the internal page
    var the_height = document.getElementById('${n}googleFrame').contentWindow.document.body.scrollHeight;
    //change the height of the iframe
    ${n}.jQuery('#${n}googleFrame').css("height", the_height + 30 + 'px');
}


</script>