/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.resource.aggr.mojo;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.DirectoryScanner;
import org.jasig.resource.aggr.ResourcesAggregator;
import org.jasig.resource.aggr.mojo.AbstractSkinResourcesAggregatorMojo;
import org.jasig.resourceserver.aggr.AggregationException;

public class BatchSkinResourcesAggregatorMojo
extends AbstractSkinResourcesAggregatorMojo {
    private File skinSourceDirectory;
    private String[] includes;
    private String[] excludes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        try {
            ResourcesAggregator aggr = this.createResourcesAggregator();
            Set<String> skinConfigurationFiles = this.findSkinConfigurationFiles();
            for (String fileName : skinConfigurationFiles) {
                log.info((CharSequence)("Aggregating: " + fileName));
                File skinConfigurationFile = new File(this.skinSourceDirectory, fileName);
                File skinOutputDirectory = new File(this.baseOutputDirectory, fileName).getParentFile();
                this.doAggregation(aggr, skinConfigurationFile, skinOutputDirectory);
            }
        }
        catch (AggregationException e) {
            throw new MojoExecutionException("aggregation failed", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException occurred", (Exception)e);
        }
    }

    private Set<String> findSkinConfigurationFiles() {
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setIncludes(this.includes);
        directoryScanner.setExcludes(this.excludes);
        directoryScanner.setBasedir(this.skinSourceDirectory);
        directoryScanner.scan();
        LinkedHashSet<String> skinConfigurationFiles = new LinkedHashSet<String>();
        for (String fileName : directoryScanner.getIncludedFiles()) {
            skinConfigurationFiles.add(fileName);
        }
        return skinConfigurationFiles;
    }
}

