/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.resourceserver.utils.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.resourceserver.aggr.om.Included;
import org.jasig.resourceserver.utils.aggr.ResourcesElementsProvider;
import org.jasig.resourceserver.utils.aggr.ResourcesElementsProviderUtils;

public class AggregationAwareFilterBean
implements Filter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Filter filter;
    private ResourcesElementsProvider resourcesElementsProvider;

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void setResourcesElementsProvider(ResourcesElementsProvider resourcesElementsProvider) {
        this.resourcesElementsProvider = resourcesElementsProvider;
    }

    public void destroy() {
        this.filter.destroy();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        if (this.resourcesElementsProvider == null) {
            ServletContext servletContext = filterConfig.getServletContext();
            this.resourcesElementsProvider = ResourcesElementsProviderUtils.getOrCreateResourcesElementsProvider(servletContext);
        }
        this.filter.init(filterConfig);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        Included includedType = this.resourcesElementsProvider.getIncludedType(httpServletRequest);
        if (includedType == Included.AGGREGATED) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Aggregation enabled, delegating to filter: " + this.filter));
            }
            this.filter.doFilter(request, response, chain);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Aggregation disabled, skipping filter: " + this.filter));
            }
            chain.doFilter(request, response);
        }
    }
}

