/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.resourceserver.utils.filter;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.resourceserver.aggr.om.Included;
import org.jasig.resourceserver.utils.aggr.ResourcesElementsProvider;
import org.jasig.resourceserver.utils.aggr.ResourcesElementsProviderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.GenericFilterBean;

public class PathBasedCacheExpirationFilter
extends GenericFilterBean {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    final Map<String, Long> DEFAULT_CACHE_PATHS = ImmutableMap.of((Object)"/**/*.aggr.min.js", (Object)TimeUnit.DAYS.toSeconds(365L), (Object)"/**/*.aggr.min.css", (Object)TimeUnit.DAYS.toSeconds(365L), (Object)"/**/*.min.js", (Object)TimeUnit.DAYS.toSeconds(365L), (Object)"/**/*.min.css", (Object)TimeUnit.DAYS.toSeconds(365L), (Object)"/rs/**/*", (Object)TimeUnit.DAYS.toSeconds(365L));
    private ResourcesElementsProvider resourcesElementsProvider;
    private Map<String, Long> cacheMaxAges;
    private Map<Long, String> cachedControlStrings;
    private final AntPathMatcher pathMatcher = new AntPathMatcher();

    public PathBasedCacheExpirationFilter() {
        this.setCacheMaxAges(this.DEFAULT_CACHE_PATHS);
    }

    public void setCacheMaxAges(Map<String, ? extends Number> cacheMaxAges) {
        ImmutableMap.Builder cacheMaxAgesBuilder = ImmutableMap.builder();
        ImmutableMap.Builder cachedControlStringsBuilder = ImmutableMap.builder();
        HashSet<Long> maxAgeLog = new HashSet<Long>();
        for (Map.Entry<String, ? extends Number> cacheMaxAgeEntry : cacheMaxAges.entrySet()) {
            Number maxAgeNum = cacheMaxAgeEntry.getValue();
            int maxAge = maxAgeNum.intValue();
            long maxAgeMillis = TimeUnit.SECONDS.toMillis(maxAge);
            cacheMaxAgesBuilder.put((Object)cacheMaxAgeEntry.getKey(), (Object)maxAgeMillis);
            if (!maxAgeLog.add(maxAgeMillis)) continue;
            cachedControlStringsBuilder.put((Object)maxAgeMillis, (Object)("public, max-age=" + maxAge));
        }
        this.cacheMaxAges = cacheMaxAgesBuilder.build();
        this.cachedControlStrings = cachedControlStringsBuilder.build();
    }

    public void setResourcesElementsProvider(ResourcesElementsProvider resourcesElementsProvider) {
        this.resourcesElementsProvider = resourcesElementsProvider;
    }

    protected void initFilterBean() throws ServletException {
        if (this.resourcesElementsProvider == null) {
            ServletContext servletContext = this.getServletContext();
            this.resourcesElementsProvider = ResourcesElementsProviderUtils.getOrCreateResourcesElementsProvider(servletContext);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest;
        Included includedType;
        if (response instanceof HttpServletResponse && request instanceof HttpServletRequest && (includedType = this.resourcesElementsProvider.getIncludedType(httpServletRequest = (HttpServletRequest)request)) == Included.AGGREGATED) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            String path = ((HttpServletRequest)request).getServletPath();
            for (Map.Entry<String, Long> entry : this.cacheMaxAges.entrySet()) {
                if (!this.pathMatcher.match(entry.getKey(), path)) continue;
                Long maxAge = entry.getValue();
                httpResponse.setDateHeader("Expires", System.currentTimeMillis() + maxAge);
                httpResponse.setHeader("Cache-Control", this.cachedControlStrings.get(maxAge));
                break;
            }
        }
        chain.doFilter(request, response);
    }
}

