/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.resourceserver.utils.taglib;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.resource.aggr.CommonsLogErrorReporter;
import org.jasig.resource.com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import org.jasig.resource.org.mozilla.javascript.ErrorReporter;
import org.jasig.resource.org.mozilla.javascript.EvaluatorException;
import org.jasig.resourceserver.aggr.om.Included;
import org.jasig.resourceserver.utils.aggr.ResourcesElementsProvider;
import org.jasig.resourceserver.utils.aggr.ResourcesElementsProviderUtils;

public class JavaScriptMinificationTag
extends BodyTagSupport {
    private static final long serialVersionUID = 1950546842057709745L;
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected final ErrorReporter jsErrorReporter = new CommonsLogErrorReporter(this.log);
    private int lineBreakColumnNumber = 10000;
    private boolean obfuscate = true;
    private boolean preserveAllSemiColons = true;
    private boolean disableOptimizations = false;

    public void setLineBreakColumnNumber(int lineBreakColumnNumber) {
        this.lineBreakColumnNumber = lineBreakColumnNumber;
    }

    public void setObfuscate(boolean obfuscate) {
        this.obfuscate = obfuscate;
    }

    public void setPreserveAllSemiColons(boolean preserveAllSemiColons) {
        this.preserveAllSemiColons = preserveAllSemiColons;
    }

    public void setDisableOptimizations(boolean disableOptimizations) {
        this.disableOptimizations = disableOptimizations;
    }

    public int doAfterBody() throws JspException {
        Reader bodyReader;
        BodyContent bc = this.getBodyContent();
        JspWriter out = bc.getEnclosingWriter();
        boolean scriptWritten = false;
        if (this.isCompressionEnabled()) {
            bodyReader = bc.getReader();
            try {
                JavaScriptCompressor jsCompressor = new JavaScriptCompressor(bodyReader, this.jsErrorReporter);
                jsCompressor.compress((Writer)out, this.lineBreakColumnNumber, this.obfuscate, false, this.preserveAllSemiColons, this.disableOptimizations);
                scriptWritten = true;
            }
            catch (EvaluatorException e) {
                this.log.warn((Object)"Failed to parse JS data to minify, falling back to non-minified JS.", (Throwable)e);
                bc.clearBody();
            }
            catch (IOException e) {
                this.log.warn((Object)"Failed to read or write JS data, falling back to non-minified JS.", (Throwable)e);
                bc.clearBody();
            }
        }
        if (!scriptWritten) {
            bodyReader = bc.getReader();
            try {
                IOUtils.copy((Reader)bodyReader, (Writer)out);
            }
            catch (IOException e) {
                throw new JspException("Failed to write JS data to JSP", (Throwable)e);
            }
        }
        return 0;
    }

    protected boolean isCompressionEnabled() {
        ServletContext servletContext = this.pageContext.getServletContext();
        ResourcesElementsProvider resourcesElementsProvider = ResourcesElementsProviderUtils.getOrCreateResourcesElementsProvider(servletContext);
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        Included includedType = resourcesElementsProvider.getIncludedType(request);
        return Included.AGGREGATED.equals((Object)includedType);
    }
}

