/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.resourceserver.web;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class AvailableResourcesController
extends AbstractController {
    private static final String BASE_PATH = "/rs/";

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ApplicationContext applicationContext = this.getApplicationContext();
        ServletContext servletContext = this.getServletContext();
        TreeMap libraries = new TreeMap();
        Set libraryPaths = servletContext.getResourcePaths(BASE_PATH);
        for (String libraryPath : libraryPaths) {
            if (!libraryPath.endsWith("/")) continue;
            String libraryName = libraryPath.substring(BASE_PATH.length(), libraryPath.length() - 1);
            if (!libraries.containsKey(libraryName)) {
                libraries.put(libraryName, new TreeMap());
            }
            Map versions = (Map)libraries.get(libraryName);
            Set versionPaths = servletContext.getResourcePaths(libraryPath);
            for (String versionPath : versionPaths) {
                if (!versionPath.endsWith("/")) continue;
                String libraryVersion = versionPath.substring(libraryPath.length(), versionPath.length() - 1);
                if (!versions.containsKey(libraryVersion)) {
                    versions.put(libraryVersion, new TreeMap());
                }
                Map resources = (Map)versions.get(libraryVersion);
                Resource[] jsResources = applicationContext.getResources(versionPath + "**/*.js");
                resources.put("js", jsResources);
                Resource[] cssResources = applicationContext.getResources(versionPath + "**/*.css");
                resources.put("css", cssResources);
            }
        }
        return new ModelAndView("availableResources", "libraries", libraries);
    }
}

