/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl;

import java.util.Date;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;
import org.jasig.schedassist.impl.DefaultAvailableScheduleReflectionServiceImpl;
import org.jasig.schedassist.model.IScheduleOwner;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service(value="availableScheduleReflectionService")
public class AsyncAvailableScheduleReflectionServiceImpl
extends DefaultAvailableScheduleReflectionServiceImpl
implements Runnable {
    private final Queue<IScheduleOwner> reflectQueue = new LinkedBlockingDeque<IScheduleOwner>();

    @Override
    public void reflectAvailableSchedule(IScheduleOwner owner) {
        boolean added;
        if (null != owner && !this.reflectQueue.contains(owner) && owner.isReflectSchedule() && (added = this.reflectQueue.add(owner))) {
            LOG.info((Object)("added owner to reflection queue: " + owner));
        }
    }

    @Override
    @Async
    public void purgeReflections(IScheduleOwner owner, Date start, Date end) {
        this.reflectQueue.remove(owner);
        super.purgeReflections(owner, start, end);
    }

    protected void processReflectQueue() {
        IScheduleOwner owner;
        while (!this.reflectQueue.isEmpty() && (owner = this.reflectQueue.poll()) != null) {
            boolean success = this.processScheduleOwner(owner);
            if (success) continue;
            LOG.warn((Object)("failed to process owner " + owner));
        }
    }

    @Override
    @Scheduled(fixedDelay=60000L)
    public void run() {
        this.processReflectQueue();
    }
}

