/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.events;

import java.text.SimpleDateFormat;
import java.util.Date;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Summary;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.impl.events.AbstractAppointmentEvent;
import org.jasig.schedassist.impl.events.AppointmentCancelledEvent;
import org.jasig.schedassist.impl.events.AppointmentCreatedEvent;
import org.jasig.schedassist.impl.events.AppointmentJoinedEvent;
import org.jasig.schedassist.impl.events.AppointmentLeftEvent;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.MessageSource;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class EmailNotificationApplicationListener
implements ApplicationListener<AbstractAppointmentEvent> {
    protected static final String NEWLINE = System.getProperty("line.separator");
    protected static final String MAILTO_PREFIX = "mailto:";
    protected static final String ORACLE_INVALID_EMAIL_DOMAIN = "@email.invalid";
    private Log LOG = LogFactory.getLog(this.getClass());
    private MailSender mailSender;
    private MessageSource messageSource;
    private String noReplyFromAddress = "no.reply.wisccal@doit.wisc.edu";

    @Autowired
    public void setMailSender(MailSender mailSender) {
        this.mailSender = mailSender;
    }

    @Autowired
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setNoReplyFromAddress(String noReplyFromAddress) {
        this.noReplyFromAddress = noReplyFromAddress;
    }

    @Async
    public void onApplicationEvent(AbstractAppointmentEvent event) {
        this.LOG.debug((Object)("email notification listener received event " + (Object)((Object)event)));
        if (event instanceof AppointmentCreatedEvent) {
            AppointmentCreatedEvent a = (AppointmentCreatedEvent)event;
            String messageBody = this.createMessageBody(a.getEvent(), a.getEventDescription(), a.getOwner());
            this.sendEmail(a.getOwner(), a.getVisitor(), a.getEvent(), messageBody);
        } else if (event instanceof AppointmentCancelledEvent) {
            AppointmentCancelledEvent a = (AppointmentCancelledEvent)event;
            String messageBody = this.cancelMessageBody(a.getEvent(), a.getCancelReason(), a.getOwner());
            this.sendEmail(a.getOwner(), a.getVisitor(), a.getEvent(), messageBody);
        } else if (event instanceof AppointmentJoinedEvent) {
            AppointmentJoinedEvent a = (AppointmentJoinedEvent)event;
            String messageBody = this.createMessageBody(a.getEvent(), null, a.getOwner());
            this.sendEmail(a.getOwner(), a.getVisitor(), a.getEvent(), messageBody);
        } else if (event instanceof AppointmentLeftEvent) {
            AppointmentLeftEvent a = (AppointmentLeftEvent)event;
            String messageBody = this.cancelMessageBody(a.getEvent(), null, a.getOwner());
            this.sendEmail(a.getOwner(), a.getVisitor(), a.getEvent(), messageBody);
        }
    }

    protected void sendEmail(IScheduleOwner owner, IScheduleVisitor visitor, VEvent event, String messageBody) {
        if (null != this.mailSender) {
            SimpleMailMessage message = new SimpleMailMessage();
            if (!EmailNotificationApplicationListener.isEmailAddressValid(owner.getCalendarAccount().getEmailAddress())) {
                message.setFrom(this.noReplyFromAddress);
                message.setTo(new String[]{visitor.getCalendarAccount().getEmailAddress()});
            } else {
                message.setFrom(owner.getCalendarAccount().getEmailAddress());
                message.setTo(new String[]{owner.getCalendarAccount().getEmailAddress(), visitor.getCalendarAccount().getEmailAddress()});
            }
            Summary summary = event.getSummary();
            if (summary != null) {
                message.setSubject(summary.getValue());
            } else {
                this.LOG.warn((Object)("event missing summary" + event));
                message.setSubject("Appointment");
            }
            message.setText(messageBody);
            this.LOG.debug((Object)("sending message: " + message.toString()));
            this.mailSender.send(message);
            this.LOG.debug((Object)"message successfully sent");
        } else {
            this.LOG.debug((Object)"no mailSender set, ignoring sendEmail call");
        }
    }

    public static boolean isEmailAddressValid(String email) {
        return !StringUtils.isBlank((String)email) && !email.endsWith(ORACLE_INVALID_EMAIL_DOMAIN);
    }

    protected String createMessageBody(VEvent event, String eventDescription, IScheduleOwner owner) {
        StringBuilder messageBody = new StringBuilder();
        messageBody.append(this.messageSource.getMessage("notify.email.introduction", (Object[])new String[]{owner.getCalendarAccount().getDisplayName()}, null));
        messageBody.append(NEWLINE);
        messageBody.append(NEWLINE);
        Summary summary = event.getSummary();
        if (summary != null) {
            messageBody.append(this.messageSource.getMessage("notify.email.title", (Object[])new String[]{summary.getValue()}, null));
            messageBody.append(NEWLINE);
        }
        SimpleDateFormat df = new SimpleDateFormat("EEE, MMM d, yyyy");
        SimpleDateFormat tf = new SimpleDateFormat("h:mm a");
        messageBody.append(df.format((Date)event.getStartDate().getDate()));
        messageBody.append(NEWLINE);
        messageBody.append(this.messageSource.getMessage("notify.email.time", (Object[])new String[]{tf.format((Date)event.getStartDate().getDate()), tf.format((Date)event.getEndDate(true).getDate())}, null));
        Location location = event.getLocation();
        if (location != null) {
            messageBody.append(NEWLINE);
            messageBody.append(this.messageSource.getMessage("notify.email.location", (Object[])new String[]{location.getValue()}, null));
        }
        messageBody.append(NEWLINE);
        if (StringUtils.isNotBlank((String)eventDescription)) {
            messageBody.append(this.messageSource.getMessage("notify.email.reason", (Object[])new String[]{eventDescription}, null));
            messageBody.append(NEWLINE);
        }
        messageBody.append(NEWLINE);
        messageBody.append(this.messageSource.getMessage("notify.email.footer", null, null));
        return messageBody.toString();
    }

    protected String cancelMessageBody(VEvent event, String cancelReason, IScheduleOwner owner) {
        StringBuilder messageBody = new StringBuilder();
        messageBody.append(this.messageSource.getMessage("notify.email.cancel", (Object[])new String[]{owner.getCalendarAccount().getDisplayName()}, null));
        messageBody.append(NEWLINE);
        messageBody.append(NEWLINE);
        Summary summary = event.getSummary();
        if (summary != null) {
            messageBody.append(this.messageSource.getMessage("notify.email.title", (Object[])new String[]{summary.getValue()}, null));
            messageBody.append(NEWLINE);
        }
        SimpleDateFormat df = new SimpleDateFormat("EEE, MMM d, yyyy");
        SimpleDateFormat tf = new SimpleDateFormat("h:mm a");
        messageBody.append(df.format((Date)event.getStartDate().getDate()));
        messageBody.append(NEWLINE);
        messageBody.append(this.messageSource.getMessage("notify.email.time", (Object[])new String[]{tf.format((Date)event.getStartDate().getDate()), tf.format((Date)event.getEndDate(true).getDate())}, null));
        messageBody.append(NEWLINE);
        if (StringUtils.isNotBlank((String)cancelReason)) {
            messageBody.append(this.messageSource.getMessage("notify.email.cancel.reason", (Object[])new String[]{cancelReason}, null));
            messageBody.append(NEWLINE);
        }
        messageBody.append(NEWLINE);
        messageBody.append(this.messageSource.getMessage("notify.email.footer", null, null));
        return messageBody.toString();
    }
}

