/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.ldap;

import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.jasig.schedassist.impl.ldap.LDAPAttributesKey;
import org.jasig.schedassist.impl.ldap.LDAPPersonCalendarAccountImpl;
import org.springframework.ldap.core.AttributesMapper;

public class DefaultAttributesMapperImpl
implements AttributesMapper {
    protected final LDAPAttributesKey ldapAttributesKey;

    public DefaultAttributesMapperImpl(LDAPAttributesKey ldapAttributesKey) {
        this.ldapAttributesKey = ldapAttributesKey;
    }

    public Object mapFromAttributes(Attributes attributes) throws NamingException {
        Map<String, String> attributesMap = this.convertToStringAttributesMap(attributes);
        LDAPPersonCalendarAccountImpl account = new LDAPPersonCalendarAccountImpl(attributesMap, this.ldapAttributesKey);
        return account;
    }

    protected final Map<String, String> convertToStringAttributesMap(Attributes attributes) throws NamingException {
        HashMap<String, String> attributesMap = new HashMap<String, String>();
        NamingEnumeration<String> attributeNames = attributes.getIDs();
        while (attributeNames.hasMore()) {
            String attributeName = attributeNames.next();
            if (this.ldapAttributesKey.getPasswordAttributeName().equalsIgnoreCase(attributeName)) continue;
            Attribute attribute = attributes.get(attributeName);
            String value = (String)attribute.get();
            if (null != value) {
                value = value.trim();
            }
            attributesMap.put(attributeName.toLowerCase(), value);
        }
        return attributesMap;
    }
}

