/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.ldap;

import com.googlecode.ehcache.annotations.Cacheable;
import com.googlecode.ehcache.annotations.KeyGenerator;
import java.util.Collections;
import java.util.List;
import javax.naming.directory.SearchControls;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.ICalendarAccountDao;
import org.jasig.schedassist.impl.ldap.DefaultAttributesMapperImpl;
import org.jasig.schedassist.impl.ldap.LDAPAttributesKey;
import org.jasig.schedassist.impl.ldap.LDAPAttributesKeyImpl;
import org.jasig.schedassist.model.ICalendarAccount;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.ldap.SizeLimitExceededException;
import org.springframework.ldap.TimeLimitExceededException;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.LikeFilter;
import org.springframework.ldap.filter.OrFilter;

public class LDAPCalendarAccountDaoImpl
implements ICalendarAccountDao {
    private static final String WILD = "*";
    private LdapTemplate ldapTemplate;
    private String baseDn = "o=isp";
    private LDAPAttributesKey ldapAttributesKey = new LDAPAttributesKeyImpl();
    private long searchResultsLimit = 50L;
    private int searchTimeLimit = 5000;
    private final Log log = LogFactory.getLog(this.getClass());

    @Autowired
    public void setLdapTemplate(LdapTemplate ldapTemplate) {
        this.ldapTemplate = ldapTemplate;
    }

    public void setBaseDn(String baseDn) {
        this.baseDn = baseDn;
    }

    @Autowired(required=false)
    public void setLdapAttributesKey(LDAPAttributesKey ldapAttributesKey) {
        this.ldapAttributesKey = ldapAttributesKey;
    }

    public void setSearchResultsLimit(long searchResultsLimit) {
        this.searchResultsLimit = searchResultsLimit;
    }

    public void setSearchTimeLimit(int searchTimeLimit) {
        this.searchTimeLimit = searchTimeLimit;
    }

    @Cacheable(cacheName="userAccountCache", keyGenerator=@KeyGenerator(name="StringCacheKeyGenerator"))
    public ICalendarAccount getCalendarAccount(String username) {
        EqualsFilter filter = new EqualsFilter(this.ldapAttributesKey.getUsernameAttributeName(), username);
        return this.executeSearch((Filter)filter);
    }

    @Cacheable(cacheName="userAccountCache", keyGenerator=@KeyGenerator(name="StringCacheKeyGenerator"))
    public ICalendarAccount getCalendarAccountFromUniqueId(String calendarUniqueId) {
        return this.getCalendarAccount(this.ldapAttributesKey.getUniqueIdentifierAttributeName(), calendarUniqueId);
    }

    @Cacheable(cacheName="userAccountCache", keyGenerator=@KeyGenerator(name="StringCacheKeyGenerator"))
    public ICalendarAccount getCalendarAccount(String attributeName, String attributeValue) {
        AndFilter filter = new AndFilter();
        filter.and((Filter)new EqualsFilter(attributeName, attributeValue));
        filter.and((Filter)new LikeFilter(this.ldapAttributesKey.getUsernameAttributeName(), WILD));
        return this.executeSearch((Filter)filter);
    }

    @Cacheable(cacheName="userAccountCache", keyGenerator=@KeyGenerator(name="StringCacheKeyGenerator"))
    public List<ICalendarAccount> searchForCalendarAccounts(String searchText) {
        AndFilter filter = new AndFilter();
        StringBuilder wildSearchText = new StringBuilder();
        wildSearchText.append(WILD);
        wildSearchText.append(searchText.replace(" ", WILD));
        wildSearchText.append(WILD);
        OrFilter orFilter = new OrFilter();
        orFilter.or((Filter)new LikeFilter(this.ldapAttributesKey.getUsernameAttributeName(), wildSearchText.toString()));
        orFilter.or((Filter)new LikeFilter(this.ldapAttributesKey.getDisplayNameAttributeName(), wildSearchText.toString()));
        filter.and((Filter)orFilter);
        filter.and((Filter)new LikeFilter(this.ldapAttributesKey.getUniqueIdentifierAttributeName(), WILD));
        return this.executeSearchReturnList((Filter)filter);
    }

    protected ICalendarAccount executeSearch(Filter searchFilter) {
        List<ICalendarAccount> results = this.executeSearchReturnList(searchFilter);
        ICalendarAccount result = (ICalendarAccount)DataAccessUtils.singleResult(results);
        return result;
    }

    protected List<ICalendarAccount> executeSearchReturnList(Filter searchFilter) {
        this.log.debug((Object)("executing search filter: " + searchFilter));
        SearchControls sc = new SearchControls();
        sc.setCountLimit(this.searchResultsLimit);
        sc.setTimeLimit(this.searchTimeLimit);
        sc.setSearchScope(2);
        List results = Collections.emptyList();
        try {
            results = this.ldapTemplate.search(this.baseDn, searchFilter.toString(), sc, (AttributesMapper)new DefaultAttributesMapperImpl(this.ldapAttributesKey));
        }
        catch (SizeLimitExceededException e) {
            this.log.debug((Object)("search filter exceeded results size limit(" + this.searchResultsLimit + "): " + searchFilter));
        }
        catch (TimeLimitExceededException e) {
            this.log.warn((Object)("search filter exceeded time limit (" + this.searchTimeLimit + " milliseconds): " + searchFilter));
        }
        return results;
    }
}

