/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.ldap;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.naming.directory.SearchControls;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.IDelegateCalendarAccountDao;
import org.jasig.schedassist.impl.ldap.DefaultDelegateAccountAttributesMapperImpl;
import org.jasig.schedassist.impl.ldap.LDAPAttributesKey;
import org.jasig.schedassist.impl.ldap.LDAPAttributesKeyImpl;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IDelegateCalendarAccount;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.ldap.SizeLimitExceededException;
import org.springframework.ldap.TimeLimitExceededException;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.LikeFilter;
import org.springframework.ldap.filter.OrFilter;

public class LDAPDelegateCalendarAccountDaoImpl
implements IDelegateCalendarAccountDao {
    private static final String WILDCARD = "*";
    private final Log log = LogFactory.getLog(this.getClass());
    private LdapOperations ldapTemplate;
    private LDAPAttributesKey ldapAttributesKey = new LDAPAttributesKeyImpl();
    private String baseDn = "o=isp";
    private long searchResultsLimit = 25L;
    private int searchTimeLimit = 10000;

    @Autowired
    public void setLdapTemplate(LdapOperations ldapTemplate) {
        this.ldapTemplate = ldapTemplate;
    }

    @Autowired
    public void setLdapAttributesKey(LDAPAttributesKey ldapAttributesKey) {
        this.ldapAttributesKey = ldapAttributesKey;
    }

    public void setBaseDn(String baseDn) {
        this.baseDn = baseDn;
    }

    public void setSearchResultsLimit(long searchResultsLimit) {
        this.searchResultsLimit = searchResultsLimit;
    }

    public void setSearchTimeLimit(int searchTimeLimit) {
        this.searchTimeLimit = searchTimeLimit;
    }

    public List<IDelegateCalendarAccount> searchForDelegates(String searchText, ICalendarAccount owner) {
        String searchTextInternal = searchText.replace(" ", WILDCARD);
        if (!searchTextInternal.endsWith(WILDCARD)) {
            searchTextInternal = searchTextInternal + WILDCARD;
        }
        AndFilter searchFilter = new AndFilter();
        OrFilter orFilter = new OrFilter();
        orFilter.or((Filter)new LikeFilter(this.ldapAttributesKey.getDisplayNameAttributeName(), searchTextInternal));
        orFilter.or((Filter)new LikeFilter(this.ldapAttributesKey.getUsernameAttributeName(), searchTextInternal));
        if (owner != null) {
            searchFilter.and((Filter)new EqualsFilter(this.ldapAttributesKey.getDelegateOwnerAttributeName(), owner.getUsername()));
        }
        searchFilter.and((Filter)orFilter);
        searchFilter.and((Filter)new LikeFilter(this.ldapAttributesKey.getUniqueIdentifierAttributeName(), WILDCARD));
        List<IDelegateCalendarAccount> results = this.executeSearchReturnList((Filter)searchFilter, owner);
        return results;
    }

    public List<IDelegateCalendarAccount> searchForDelegates(String searchText) {
        return this.searchForDelegates(searchText, null);
    }

    public IDelegateCalendarAccount getDelegate(String accountName) {
        return this.getDelegate(accountName, null);
    }

    public IDelegateCalendarAccount getDelegate(String accountName, ICalendarAccount owner) {
        AndFilter searchFilter = new AndFilter();
        searchFilter.and((Filter)new EqualsFilter(this.ldapAttributesKey.getDisplayNameAttributeName(), accountName));
        if (owner != null) {
            searchFilter.and((Filter)new EqualsFilter(this.ldapAttributesKey.getDelegateOwnerAttributeName(), owner.getUsername()));
        }
        searchFilter.and((Filter)new LikeFilter(this.ldapAttributesKey.getUniqueIdentifierAttributeName(), WILDCARD));
        List<IDelegateCalendarAccount> results = this.executeSearchReturnList((Filter)searchFilter, owner);
        IDelegateCalendarAccount delegate = (IDelegateCalendarAccount)DataAccessUtils.singleResult(results);
        return delegate;
    }

    public IDelegateCalendarAccount getDelegateByUniqueId(String accountUniqueId) {
        return this.getDelegateByUniqueId(accountUniqueId, null);
    }

    public IDelegateCalendarAccount getDelegateByUniqueId(String accountUniqueId, ICalendarAccount owner) {
        AndFilter searchFilter = new AndFilter();
        searchFilter.and((Filter)new EqualsFilter(this.ldapAttributesKey.getUniqueIdentifierAttributeName(), accountUniqueId));
        if (owner != null) {
            searchFilter.and((Filter)new EqualsFilter(this.ldapAttributesKey.getDelegateOwnerAttributeName(), owner.getUsername()));
        }
        List<IDelegateCalendarAccount> results = this.executeSearchReturnList((Filter)searchFilter, owner);
        IDelegateCalendarAccount delegate = (IDelegateCalendarAccount)DataAccessUtils.singleResult(results);
        return delegate;
    }

    protected List<IDelegateCalendarAccount> executeSearchReturnList(Filter searchFilter, ICalendarAccount owner) {
        SearchControls searchControls = new SearchControls();
        searchControls.setCountLimit(this.searchResultsLimit);
        searchControls.setTimeLimit(this.searchTimeLimit);
        searchControls.setSearchScope(2);
        List results = Collections.emptyList();
        try {
            results = this.ldapTemplate.search(this.baseDn, searchFilter.toString(), searchControls, (AttributesMapper)new DefaultDelegateAccountAttributesMapperImpl(this.ldapAttributesKey, owner));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("search " + searchFilter + " returned " + results.size() + " results"));
            }
            Collections.sort(results, new DelegateDisplayNameComparator());
        }
        catch (SizeLimitExceededException e) {
            this.log.debug((Object)("search filter exceeded size limit (" + this.searchResultsLimit + "): " + searchFilter));
        }
        catch (TimeLimitExceededException e) {
            this.log.debug((Object)("search filter exceeded time limit(" + this.searchTimeLimit + " milliseconds): " + searchFilter));
        }
        return results;
    }

    private static class DelegateDisplayNameComparator
    implements Comparator<IDelegateCalendarAccount> {
        private DelegateDisplayNameComparator() {
        }

        @Override
        public int compare(IDelegateCalendarAccount o1, IDelegateCalendarAccount o2) {
            return new CompareToBuilder().append((Object)o1.getDisplayName(), (Object)o2.getDisplayName()).toComparison();
        }
    }
}

