/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.ldap;

import java.util.HashMap;
import java.util.Map;
import org.jasig.schedassist.impl.ldap.LDAPAttributesKey;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IDelegateCalendarAccount;

class LDAPDelegateCalendarAccountImpl
implements IDelegateCalendarAccount {
    private static final long serialVersionUID = 53706L;
    private final String calendarUniqueId;
    private final String emailAddress;
    private final String displayName;
    private final String username;
    private final boolean eligible;
    private final String location;
    private final String contactInformation;
    private Map<String, String> attributesMap = new HashMap<String, String>();
    private ICalendarAccount accountOwner;

    public LDAPDelegateCalendarAccountImpl(Map<String, String> attributes, LDAPAttributesKey ldapAttributesKey) {
        this(attributes, ldapAttributesKey, null);
    }

    public LDAPDelegateCalendarAccountImpl(Map<String, String> attributes, LDAPAttributesKey ldapAttributesKey, ICalendarAccount accountOwner) {
        this.attributesMap = attributes;
        this.accountOwner = accountOwner;
        this.calendarUniqueId = attributes.get(ldapAttributesKey.getUniqueIdentifierAttributeName());
        this.displayName = attributes.get(ldapAttributesKey.getDisplayNameAttributeName());
        this.emailAddress = attributes.get(ldapAttributesKey.getEmailAddressAttributeName());
        this.username = attributes.get(ldapAttributesKey.getUsernameAttributeName());
        this.location = attributes.get(ldapAttributesKey.getDelegateLocationAttributeName());
        this.contactInformation = attributes.get(ldapAttributesKey.getDelegateContactInformationAttributeName());
        this.eligible = ldapAttributesKey.evaluateEligibilityAttributeValue(attributes);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getCalendarLoginId() {
        return this.getUsername();
    }

    public String getCalendarUniqueId() {
        return this.calendarUniqueId;
    }

    public String getAttributeValue(String attributeName) {
        return this.attributesMap.get(attributeName);
    }

    public Map<String, String> getAttributes() {
        return this.attributesMap;
    }

    public boolean isEligible() {
        return this.eligible;
    }

    public ICalendarAccount getAccountOwner() {
        return this.accountOwner;
    }

    public String getAccountOwnerUsername() {
        if (this.accountOwner != null) {
            return this.accountOwner.getUsername();
        }
        return null;
    }

    public String getLocation() {
        return this.location;
    }

    public String getContactInformation() {
        return this.contactInformation;
    }
}

