/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.owner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.ICalendarAccountDao;
import org.jasig.schedassist.MutableRelationshipDao;
import org.jasig.schedassist.impl.owner.OwnerDao;
import org.jasig.schedassist.impl.owner.OwnerDefinedRelationship;
import org.jasig.schedassist.impl.owner.OwnerDefinedRelationshipRowMapper;
import org.jasig.schedassist.impl.visitor.NotAVisitorException;
import org.jasig.schedassist.impl.visitor.VisitorDao;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IScheduleOwner;
import org.jasig.schedassist.model.IScheduleVisitor;
import org.jasig.schedassist.model.Relationship;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Service;

@Service
@Qualifier(value="adhoc")
public class OwnerDefinedRelationshipDaoImpl
implements MutableRelationshipDao {
    private Log LOG = LogFactory.getLog(this.getClass());
    private SimpleJdbcTemplate simpleJdbcTemplate;
    private ICalendarAccountDao calendarAccountDao;
    private OwnerDao ownerDao;
    private VisitorDao visitorDao;

    @Autowired(required=true)
    public void setDataSource(DataSource dataSource) {
        this.simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    @Autowired(required=true)
    public void setCalendarAccountDao(@Qualifier(value="composite") ICalendarAccountDao calendarAccountDao) {
        this.calendarAccountDao = calendarAccountDao;
    }

    @Autowired(required=true)
    public void setOwnerDao(OwnerDao ownerDao) {
        this.ownerDao = ownerDao;
    }

    @Autowired(required=true)
    public void setVisitorDao(VisitorDao visitorDao) {
        this.visitorDao = visitorDao;
    }

    public List<Relationship> forOwner(IScheduleOwner owner) {
        List relationships = this.simpleJdbcTemplate.query("select * from owner_adhoc_authz where owner_username = ?", (RowMapper)new OwnerDefinedRelationshipRowMapper(), new Object[]{owner.getCalendarAccount().getUsername()});
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        for (OwnerDefinedRelationship stored : relationships) {
            ICalendarAccount calendarUser = this.calendarAccountDao.getCalendarAccount(stored.getVisitorUsername());
            if (null == calendarUser) {
                this.LOG.warn((Object)("calendarUser not found for owner in " + stored));
                continue;
            }
            try {
                IScheduleVisitor visitor = this.visitorDao.toVisitor(calendarUser);
                if (null != owner) {
                    Relationship relationship = new Relationship();
                    relationship.setOwner(owner);
                    relationship.setVisitor(visitor);
                    relationship.setDescription(stored.getRelationship());
                    results.add(relationship);
                    continue;
                }
                this.LOG.warn((Object)("owner not registered for record " + stored));
            }
            catch (NotAVisitorException e) {
                this.LOG.warn((Object)("calendarUser found but not a visitor " + stored));
            }
        }
        return results;
    }

    public List<Relationship> forVisitor(IScheduleVisitor visitor) {
        List relationships = this.simpleJdbcTemplate.query("select * from owner_adhoc_authz where visitor_username = ?", (RowMapper)new OwnerDefinedRelationshipRowMapper(), new Object[]{visitor.getCalendarAccount().getUsername()});
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        for (OwnerDefinedRelationship stored : relationships) {
            ICalendarAccount calendarUser = this.calendarAccountDao.getCalendarAccount(stored.getOwnerUsername());
            if (null == calendarUser) {
                this.LOG.warn((Object)("calendarUser not found for owner in " + stored));
                continue;
            }
            IScheduleOwner owner = this.ownerDao.locateOwner(calendarUser);
            if (null != owner) {
                Relationship relationship = new Relationship();
                relationship.setOwner(owner);
                relationship.setVisitor(visitor);
                relationship.setDescription(stored.getRelationship());
                results.add(relationship);
                continue;
            }
            this.LOG.warn((Object)("owner not registered for record " + stored));
        }
        return results;
    }

    public Relationship createRelationship(IScheduleOwner owner, IScheduleVisitor visitor, String relationship) {
        OwnerDefinedRelationship stored = this.internalRetrieveRelationship(owner.getCalendarAccount().getUsername(), visitor.getCalendarAccount().getUsername());
        if (null == stored) {
            this.simpleJdbcTemplate.update("insert into owner_adhoc_authz (owner_username, relationship, visitor_username) values (?, ?, ?)", new Object[]{owner.getCalendarAccount().getUsername(), relationship, visitor.getCalendarAccount().getUsername()});
            this.LOG.info((Object)("stored owner defined relationship: " + owner.getCalendarAccount().getUsername() + ", " + relationship + ", " + visitor.getCalendarAccount().getUsername()));
        } else {
            this.simpleJdbcTemplate.update("update owner_adhoc_authz set relationship = ? where owner_username = ? and visitor_username = ?", new Object[]{relationship, owner.getCalendarAccount().getUsername(), visitor.getCalendarAccount().getUsername()});
            this.LOG.debug((Object)("proposed authorization already stored for " + visitor + ", updated relationship description"));
        }
        Relationship result = new Relationship();
        result.setOwner(owner);
        result.setVisitor(visitor);
        result.setDescription(relationship);
        return result;
    }

    public void destroyRelationship(IScheduleOwner owner, IScheduleVisitor visitor) {
        this.internalDeleteRelationship(owner.getCalendarAccount().getUsername(), visitor.getCalendarAccount().getUsername());
    }

    protected void internalDeleteRelationship(String ownerUsername, String visitorUsername) {
        int rowsAffected = this.simpleJdbcTemplate.update("delete from owner_adhoc_authz where owner_username = ? and visitor_username = ?", new Object[]{ownerUsername, visitorUsername});
        if (rowsAffected > 0) {
            this.LOG.info((Object)("removed owner defined relationship: " + ownerUsername + ", " + visitorUsername));
        } else {
            this.LOG.debug((Object)("no authorization stored for visitor " + visitorUsername + " and owner " + ownerUsername));
        }
    }

    protected OwnerDefinedRelationship internalRetrieveRelationship(String ownerUsername, String visitorUsername) {
        List relationships = this.simpleJdbcTemplate.query("select * from owner_adhoc_authz where owner_username = ? and visitor_username = ?", (RowMapper)new OwnerDefinedRelationshipRowMapper(), new Object[]{ownerUsername, visitorUsername});
        return (OwnerDefinedRelationship)DataAccessUtils.singleResult((Collection)relationships);
    }
}

