/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.owner;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.impl.owner.OwnerAuthorization;
import org.jasig.schedassist.model.ICalendarAccount;
import org.springframework.beans.factory.annotation.Required;

public class RequiredAttributeOwnerAuthorizationImpl
implements OwnerAuthorization {
    private Log LOG = LogFactory.getLog(this.getClass());
    private String attributeName = "wisceduisisadvisoremplid";
    private Pattern attributeValuePattern;

    @Required
    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public void setAttributeValuePattern(String attributeValuePattern) {
        this.attributeValuePattern = Pattern.compile(attributeValuePattern);
    }

    @Override
    public boolean isEligible(ICalendarAccount user) {
        String userAttributeValue = user.getAttributeValue(this.attributeName);
        if (null != this.attributeValuePattern) {
            Matcher m = this.attributeValuePattern.matcher(userAttributeValue);
            if (m.matches()) {
                this.LOG.debug((Object)("user is eligible " + user));
                return true;
            }
        } else if (!StringUtils.isBlank((String)"userAttributeValue")) {
            this.LOG.debug((Object)("user is eligible " + user));
            return true;
        }
        this.LOG.debug((Object)("user is not eligible " + user));
        return false;
    }
}

