/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl.statistics;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.schedassist.impl.EventType;
import org.jasig.schedassist.impl.owner.OwnerDao;
import org.jasig.schedassist.impl.statistics.AppointmentEvent;
import org.jasig.schedassist.impl.statistics.AppointmentEventRowMapper;
import org.jasig.schedassist.impl.statistics.DailyEventSummary;
import org.jasig.schedassist.impl.statistics.StatisticsDao;
import org.jasig.schedassist.model.CommonDateOperations;
import org.jasig.schedassist.model.IScheduleOwner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Service;

@Service(value="statisticsDao")
public class SpringJDBCStatisticsDaoImpl
implements StatisticsDao {
    private static final Log LOG = LogFactory.getLog(SpringJDBCStatisticsDaoImpl.class);
    private OwnerDao ownerDao;
    private SimpleJdbcTemplate simpleJdbcTemplate;

    @Autowired
    public void setDataSource(DataSource dataSource) {
        this.simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    @Autowired
    public void setOwnerDao(OwnerDao ownerDao) {
        this.ownerDao = ownerDao;
    }

    @Override
    public List<DailyEventSummary> getEventCounts(Date startTime, Date endTime) {
        List dailyCounts = this.simpleJdbcTemplate.query("select month,day,year,count(*) as num_events from (select to_char(event_timestamp,'MM') as month, to_char(event_timestamp,'DD') as day, to_char(event_timestamp,'YYYY') as year from EVENT_STATISTICS where EVENT_TIMESTAMP >= ? and EVENT_TIMESTAMP <= ?) group by year,month,day order by year,month,day", (RowMapper)new DailyEventSummaryRowMapper(), new Object[]{startTime, endTime});
        return dailyCounts;
    }

    @Override
    public List<DailyEventSummary> getEventCounts(Date startTime, Date endTime, EventType eventType) {
        List dailyCounts = this.simpleJdbcTemplate.query("select month,day,year,count(*) as num_events from (select to_char(event_timestamp,'MM') as month, to_char(event_timestamp,'DD') as day, to_char(event_timestamp,'YYYY') as year from EVENT_STATISTICS where EVENT_TIMESTAMP >= ? and EVENT_TIMESTAMP <= ? and EVENT_TYPE = ?) group by year,month,day order by year,month,day", (RowMapper)new DailyEventSummaryRowMapper(), new Object[]{startTime, endTime, eventType.toString()});
        return dailyCounts;
    }

    @Override
    public List<AppointmentEvent> getEvents(Date startTime, Date endTime) {
        List results = this.simpleJdbcTemplate.query("select event_id,owner_id,visitor_id,event_type,event_timestamp,event_start from event_statistics where event_timestamp >= ? and event_timestamp <= ?", (RowMapper)new AppointmentEventRowMapper(this.ownerDao), new Object[]{startTime, endTime});
        return results;
    }

    @Override
    public List<AppointmentEvent> getEvents(IScheduleOwner owner, Date startTime, Date endTime) {
        List results = this.simpleJdbcTemplate.query("select event_id,owner_id,visitor_id,event_type,event_timestamp,event_start from event_statistics where owner_id = ? and event_timestamp >= ? and event_timestamp <= ?", (RowMapper)new AppointmentEventRowMapper(this.ownerDao), new Object[]{owner.getId(), startTime, endTime});
        return results;
    }

    @Override
    public List<AppointmentEvent> getEvents(IScheduleOwner owner, Date startTime, Date endTime, EventType eventType) {
        List results = this.simpleJdbcTemplate.query("select event_id,owner_id,visitor_id,event_type,event_timestamp,event_start from event_statistics where owner_id = ? and event_timestamp >= ? and event_timestamp <= ? and event_type = ?", (RowMapper)new AppointmentEventRowMapper(this.ownerDao), new Object[]{owner.getId(), startTime, endTime, eventType.toString()});
        return results;
    }

    @Override
    public List<AppointmentEvent> getEvents(IScheduleOwner owner, Date startTime, Date endTime, List<EventType> eventTypes) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("ownerId", (Object)owner.getId());
        parameterSource.addValue("startTime", (Object)startTime);
        parameterSource.addValue("endTime", (Object)endTime);
        parameterSource.addValue("eventTypes", eventTypes);
        List results = this.simpleJdbcTemplate.query("select event_id,owner_id,visitor_id,event_type,event_timestamp,event_start from event_statistics where owner_id = :ownerId and event_timestamp >= :startTime and event_timestamp <= :endTime and event_type in (:eventTypes)", (RowMapper)new AppointmentEventRowMapper(this.ownerDao), (SqlParameterSource)parameterSource);
        return results;
    }

    @Override
    public List<AppointmentEvent> getEvents(IScheduleOwner owner, String visitorUsername, Date startTime, Date endTime) {
        List results = this.simpleJdbcTemplate.query("select event_id,owner_id,visitor_id,event_type,event_timestamp,event_start from event_statistics where owner_id = ? and visitor_id = ? and event_timestamp >= ? and event_timestamp <= ?", (RowMapper)new AppointmentEventRowMapper(this.ownerDao), new Object[]{owner.getId(), visitorUsername, startTime, endTime});
        return results;
    }

    @Override
    public List<AppointmentEvent> getEvents(IScheduleOwner owner, String visitorUsername, Date startTime, Date endTime, EventType eventType) {
        List results = this.simpleJdbcTemplate.query("select event_id,owner_id,visitor_id,event_type,event_timestamp,event_start from event_statistics where owner_id = ? and visitor_id = ? and event_timestamp >= ? and event_timestamp <= ? and event_type = ?", (RowMapper)new AppointmentEventRowMapper(this.ownerDao), new Object[]{owner.getId(), visitorUsername, startTime, endTime, eventType.toString()});
        return results;
    }

    @Override
    public List<AppointmentEvent> getEvents(IScheduleOwner owner, String visitorUsername, Date startTime, Date endTime, List<EventType> eventTypes) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("ownerId", (Object)owner.getId());
        parameterSource.addValue("visitorId", (Object)visitorUsername);
        parameterSource.addValue("startTime", (Object)startTime);
        parameterSource.addValue("endTime", (Object)endTime);
        parameterSource.addValue("eventTypes", eventTypes);
        List results = this.simpleJdbcTemplate.query("select event_id,owner_id,visitor_id,event_type,event_timestamp,event_start from event_statistics where owner_id = :ownerId and visitor_id = :visitorId and event_timestamp >= :startTime and event_timestamp <= :endTime and event_type in (:eventTypes)", (RowMapper)new AppointmentEventRowMapper(this.ownerDao), (SqlParameterSource)parameterSource);
        return results;
    }

    private static class DailyCount {
        private String year;
        private String month;
        private String day;
        private long count;

        private DailyCount() {
        }

        public long getCount() {
            return this.count;
        }

        public void setYear(String year) {
            this.year = year;
        }

        public void setMonth(String month) {
            this.month = month;
        }

        public void setDay(String day) {
            this.day = day;
        }

        public void setCount(long count) {
            this.count = count;
        }

        public Date getDate() {
            if (this.year == null || this.month == null || this.day == null) {
                return null;
            }
            SimpleDateFormat df = CommonDateOperations.getDateFormat();
            try {
                Date date = df.parse(this.year + this.month + this.day);
                return DateUtils.truncate((Date)date, (int)5);
            }
            catch (ParseException e) {
                LOG.debug((Object)("failed to parse " + this.year + this.month + this.day), (Throwable)e);
                return null;
            }
        }

        public DailyEventSummary toDailyEventSummary() {
            DailyEventSummary result = new DailyEventSummary();
            result.setDate(this.getDate());
            result.setEventCount(this.getCount());
            return result;
        }
    }

    protected static class DailyEventSummaryRowMapper
    implements RowMapper<DailyEventSummary> {
        protected DailyEventSummaryRowMapper() {
        }

        public DailyEventSummary mapRow(ResultSet rs, int rowNum) throws SQLException {
            DailyCount result = new DailyCount();
            result.setYear(rs.getString("year"));
            result.setMonth(rs.getString("month"));
            result.setDay(rs.getString("day"));
            result.setCount(rs.getLong("num_events"));
            return result.toDailyEventSummary();
        }
    }
}

