/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.schedassist.impl;

import java.util.List;
import org.jasig.schedassist.ICalendarAccountDao;
import org.jasig.schedassist.IDelegateCalendarAccountDao;
import org.jasig.schedassist.model.ICalendarAccount;
import org.jasig.schedassist.model.IDelegateCalendarAccount;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Qualifier(value="composite")
public final class CompositeCalendarAccountDaoImpl
implements ICalendarAccountDao {
    private ICalendarAccountDao calendarAccountDao;
    private IDelegateCalendarAccountDao delegateCalendarAccountDao;

    @Autowired
    public void setCalendarAccountDao(ICalendarAccountDao calendarAccountDao) {
        this.calendarAccountDao = calendarAccountDao;
    }

    @Autowired
    public void setDelegateCalendarAccountDao(IDelegateCalendarAccountDao delegateCalendarAccountDao) {
        this.delegateCalendarAccountDao = delegateCalendarAccountDao;
    }

    public ICalendarAccount getCalendarAccount(String username) {
        IDelegateCalendarAccount delegate;
        ICalendarAccount person = this.calendarAccountDao.getCalendarAccount(username);
        if (null == person && null != (delegate = this.delegateCalendarAccountDao.getDelegate(username))) {
            return delegate;
        }
        return person;
    }

    public ICalendarAccount getCalendarAccount(String attributeName, String attributeValue) {
        ICalendarAccount person = this.calendarAccountDao.getCalendarAccount(attributeName, attributeValue);
        return person;
    }

    public ICalendarAccount getCalendarAccountFromUniqueId(String calendarUniqueId) {
        IDelegateCalendarAccount delegate;
        ICalendarAccount person = this.calendarAccountDao.getCalendarAccountFromUniqueId(calendarUniqueId);
        if (null == person && null != (delegate = this.delegateCalendarAccountDao.getDelegateByUniqueId(calendarUniqueId))) {
            return delegate;
        }
        return person;
    }

    public List<ICalendarAccount> searchForCalendarAccounts(String searchText) {
        List people = this.calendarAccountDao.searchForCalendarAccounts(searchText);
        return people;
    }
}

